/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client.response;

import com.alibaba.nacos.common.http.client.response.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.HttpClientUtils;

public class DefaultClientHttpResponse
implements HttpClientResponse {
    private HttpResponse response;
    private Header responseHeader;

    public DefaultClientHttpResponse(HttpResponse response) {
        this.response = response;
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @Override
    public Header getHeaders() {
        if (this.responseHeader == null) {
            org.apache.http.Header[] allHeaders;
            this.responseHeader = Header.newInstance();
            for (org.apache.http.Header header : allHeaders = this.response.getAllHeaders()) {
                this.responseHeader.addParam(header.getName(), header.getValue());
            }
        }
        return this.responseHeader;
    }

    @Override
    public InputStream getBody() throws IOException {
        return this.response.getEntity().getContent();
    }

    @Override
    public void close() {
        try {
            if (this.response != null) {
                HttpClientUtils.closeQuietly(this.response);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

