/*
 * Decompiled with CFR 0.152.
 */
package com.volar.systemdev.sentinel;

import common.config.tools.config.ConfigTools3;

public class SentinelUtils {
    public static void load() {
        String projectName = ConfigTools3.getString("sentinel.project.name", "vod-meta-api");
        System.setProperty("project.name", projectName);
        String webContextUnity = ConfigTools3.getString("sentinel.web-context-unify", "true");
        System.setProperty("spring.cloud.sentinel.web-context-unify", webContextUnity);
        String[] sentinelConfigs = new String[]{"spring.cloud.sentinel.enabled", "spring.cloud.sentinel.eager", "spring.cloud.sentinel.transport.port", "spring.cloud.sentinel.transport.dashboard", "spring.cloud.sentinel.transport.heartbeat-interval-ms", "spring.cloud.sentinel.transport.client-ip", "spring.cloud.sentinel.filter.order", "spring.cloud.sentinel.filter.url-patterns", "spring.cloud.sentinel.filter.enabled", "spring.cloud.sentinel.metric.charset", "spring.cloud.sentinel.metric.file-single-size", "spring.cloud.sentinel.metric.file-total-count", "spring.cloud.sentinel.log.dir", "spring.cloud.sentinel.log.switch-pid", "spring.cloud.sentinel.servlet.block-page", "spring.cloud.sentinel.flow.cold-factor", "spring.cloud.sentinel.zuul.order.pre", "spring.cloud.sentinel.zuul.order.post", "spring.cloud.sentinel.zuul.order.error", "spring.cloud.sentinel.scg.fallback.mode", "spring.cloud.sentinel.scg.fallback.redirect", "spring.cloud.sentinel.scg.fallback.response-body", "spring.cloud.sentinel.scg.fallback.response-status", "spring.cloud.sentinel.scg.fallback.content-type"};
        for (int i2 = 0; i2 < sentinelConfigs.length; ++i2) {
            String sentinelConfig = sentinelConfigs[i2];
            String vodConfigKey = sentinelConfig.replace("spring.cloud.", "");
            String vodConfigValue = ConfigTools3.getString(vodConfigKey, null);
            if (vodConfigValue == null) continue;
            System.setProperty(sentinelConfig, vodConfigValue);
        }
        boolean enabled = ConfigTools3.getBoolean("sentinel.enabled", false);
        System.setProperty("spring.cloud.sentinel.enabled", String.valueOf(enabled));
        String logPath = ConfigTools3.getString("sentinel.log.dir", "./logs/sentinel");
        System.setProperty("spring.cloud.sentinel.log.dir", logPath);
        System.setProperty("spring.cloud.sentinel.filter.enabled", "true");
        if (enabled) {
            String[] sentinelRuleTypes = new String[]{"flow", "degrade", "param-flow", "system", "authority"};
            for (int i3 = 0; i3 < sentinelRuleTypes.length; ++i3) {
                String ruleType = sentinelRuleTypes[i3];
                String nacosServerAddr = ConfigTools3.getString("sentinel.datasource.rules.nacos.server-addr", "");
                String nacosUsername = ConfigTools3.getString("sentinel.datasource.rules.nacos.username", "");
                String nacosPassword = ConfigTools3.getString("sentinel.datasource.rules.nacos.password", "");
                String nacosNamespace = ConfigTools3.getString("sentinel.datasource.rules.nacos.namespace", "sentinel");
                String nacosDataId = projectName + "-" + ruleType + "-rules";
                String nacosGroupId = ConfigTools3.getString("sentinel.datasource.rules.nacos.groupId", "SENTINEL_GROUP");
                String nacosDataType = ConfigTools3.getString("sentinel.datasource.rules.nacos.data-type", "json");
                String keyPrefix = "spring.cloud.sentinel.datasource." + ruleType + "-rules.nacos.";
                System.setProperty(keyPrefix + "server-addr", nacosServerAddr);
                System.setProperty(keyPrefix + "username", nacosUsername);
                System.setProperty(keyPrefix + "password", nacosPassword);
                System.setProperty(keyPrefix + "namespace", nacosNamespace);
                System.setProperty(keyPrefix + "dataId", nacosDataId);
                System.setProperty(keyPrefix + "groupId", nacosGroupId);
                System.setProperty(keyPrefix + "data-type", nacosDataType);
                System.setProperty(keyPrefix + "rule-type", ruleType);
            }
        }
    }
}

