/*
 * Decompiled with CFR 0.152.
 */
package com.volar.systemdev.sentinel.alarm;

import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import com.volar.systemdev.sentinel.alarm.SentinelAlarmService;
import com.volar.systemdev.sentinel.util.HostInfoUtil;
import com.volar.systemdev.sentinel.util.TimeUtil;
import common.config.tools.config.ConfigTools3;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VodBlockExceptionHandler
implements BlockExceptionHandler {
    private static Logger log = LoggerFactory.getLogger(VodBlockExceptionHandler.class);
    @Autowired
    SentinelAlarmService sentinelAlarmService;
    private String hostName;

    @PostConstruct
    private void init() {
        this.hostName = HostInfoUtil.getHostAddress();
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, BlockException e) throws Exception {
        String projectName = ConfigTools3.getString("sentinel.alarm.project.name", "");
        String uri = request.getRequestURI();
        StringBuilder infoSb = new StringBuilder();
        StringBuilder keySb = new StringBuilder();
        infoSb.append("Title: ").append("sentinel alarm").append("\n");
        infoSb.append("Project: ").append(projectName).append("\n");
        infoSb.append("HostName: ").append(this.hostName).append("\n");
        infoSb.append("Time: ").append(TimeUtil.getCurrentTimeString());
        infoSb.append("Uri: ").append(uri).append("\n");
        infoSb.append("Info: ");
        keySb.append("Project:").append(projectName).append(",");
        keySb.append("HostName:").append(this.hostName).append(",");
        keySb.append("Uri:").append(uri).append(",");
        String info = "";
        if (e instanceof SystemBlockException) {
            info = "blocked by sentinel(system limiting)";
            log.error("handle(),blocked by sentinel(system limiting),{}", (Object)this.getExpInfo(e));
        } else if (e instanceof FlowException) {
            info = "blocked by sentinel(flow limiting)";
            log.error("handle(),blocked by sentinel(flow limiting),{}", (Object)this.getExpInfo(e));
        } else if (e instanceof DegradeException) {
            info = "blocked by sentinel(degrade limiting)";
            log.error("handle(),blocked by sentinel(degrade limiting),{}", (Object)this.getExpInfo(e));
        } else if (e instanceof AuthorityException) {
            info = "blocked by sentinel(authority limiting)";
            log.error("handle(),blocked by sentinel(authority limiting),{}", (Object)this.getExpInfo(e));
        } else if (e instanceof ParamFlowException) {
            info = "blocked by sentinel(para-flow limiting)";
            log.error("handle(),blocked by sentinel(para-flow limiting),{}", (Object)this.getExpInfo(e));
        } else {
            info = "blocked by sentinel";
            log.error("handle(),blocked by sentinel,{}", (Object)this.getExpInfo(e));
        }
        infoSb.append(info);
        keySb.append(info);
        this.sentinelAlarmService.alarm(keySb.toString(), infoSb.toString());
        throw e;
    }

    private String getExpInfo(BlockException e) {
        BlockException ex;
        if (e == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ruleLimitApp:").append(e.getRuleLimitApp());
        if (e instanceof SystemBlockException) {
            ex = (SystemBlockException)e;
            sb.append(",").append("resourceName:").append(((SystemBlockException)ex).getResourceName());
            sb.append(",").append("limitType:").append(((SystemBlockException)ex).getLimitType());
        } else if (!(e instanceof FlowException) && !(e instanceof DegradeException) && !(e instanceof AuthorityException) && e instanceof ParamFlowException) {
            ex = (ParamFlowException)e;
            sb.append(",").append("resourceName:").append(((ParamFlowException)ex).getResourceName());
            sb.append(",").append("limitParam:").append(((ParamFlowException)ex).getLimitParam());
        }
        AbstractRule r = e.getRule();
        if (r != null) {
            sb.append(",").append("rule.id:").append(r.getId());
            sb.append(",").append("rule.limitApp:").append(r.getLimitApp());
            sb.append(",").append("rule.resource:").append(r.getResource());
        }
        return sb.toString();
    }
}

