/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config.loader.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import common.config.tools.config.loader.json.JsonLoader;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerialize {
    private static final Logger logger = LoggerFactory.getLogger(JsonSerialize.class);

    public static Object loadJson(File file, TypeReference typeReference) {
        if (typeReference == null) {
            logger.info("Can NOT find Type for json,skip[{}]", (Object)file.getAbsolutePath());
            return null;
        }
        return JsonSerialize.fromJson(file, typeReference);
    }

    public static Object fromJson(File json, TypeReference typeReference) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            String jsonStr = JsonLoader.readToString(json);
            return objectMapper.readValue(jsonStr, typeReference);
        }
        catch (IOException e) {
            logger.error("Load Json[{}] exception:{}", (Object)json.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, TypeReference typeReference) {
        if (Strings.isNullOrEmpty(json)) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            logger.error("Load Json[{}] exception:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, Class clazz) {
        if (Strings.isNullOrEmpty(json)) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            logger.error("Load Json[{}] exception:{}", (Object)json, (Object)e);
            return null;
        }
    }
}

