/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.configcenter.common;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOverrideTools {
    private static final Logger logger = LoggerFactory.getLogger(ConfigOverrideTools.class);
    private static final String NO_LEVELS = "";
    private static Map<Integer, String> levelsMap = Maps.newHashMap();

    public static void initLevels(String project, String module, String env, String region) {
        List<String> list = Arrays.asList(project, module, env, region);
        levelsMap.put(1, NO_LEVELS);
        for (int i2 = 0; i2 < list.size() && !Strings.isNullOrEmpty(list.get(i2)) && levelsMap.size() <= 5; ++i2) {
            if (i2 == 0) {
                levelsMap.put(i2 + 2, list.get(i2));
            } else {
                levelsMap.put(i2 + 2, levelsMap.get(i2 + 1) + "." + list.get(i2));
            }
            logger.info("[Init levels:{},{}th]", (Object)list.get(i2), (Object)i2);
        }
    }

    public static Map<String, Integer> getDataIdsWithWeights(String configFileName) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(configFileName, 1);
        for (int i2 = 2; i2 <= levelsMap.size(); ++i2) {
            if (!Objects.nonNull(levelsMap.get(i2))) continue;
            logger.info("[Get DataID:{},weight:{}]", (Object)(levelsMap.get(i2) + "." + configFileName), (Object)i2);
            map.put(levelsMap.get(i2) + "." + configFileName, i2);
        }
        return map;
    }

    public static int getConfigFileWight(String dataId) {
        for (int i2 = levelsMap.size(); i2 > 1; --i2) {
            if (!Objects.nonNull(levelsMap.get(i2)) || !dataId.contains(levelsMap.get(i2) + ".")) continue;
            logger.info("[Judge dataID:{},weight:{}]", (Object)dataId, (Object)i2);
            return i2;
        }
        logger.info("[Judge DataID:{},weight:{}]", (Object)dataId, (Object)1);
        return 1;
    }

    public static String getConfigFileNameFromDataId(String dataId, int weight) {
        if (weight <= 1) {
            return dataId;
        }
        return dataId.substring(levelsMap.get(weight).length() + 1);
    }
}

