/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.model;

import com.google.common.base.Strings;
import common.config.tools.model.ConfigCenterConfigDTO;
import common.config.tools.model.LocalConfigDTO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigToolConfigDTO
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigToolConfigDTO.class);
    private String project;
    private String module;
    private String env;
    private String region;
    private int runMode = 3;
    private List<String> propertiesExtension = Arrays.asList("config", "properties");
    private LocalConfigDTO localConfig = null;
    private ConfigCenterConfigDTO configCenterConfig = null;

    public ConfigToolConfigDTO() {
    }

    public ConfigToolConfigDTO(int runMode, String path) {
        this.runMode = runMode;
        this.localConfig = new LocalConfigDTO(path);
    }

    public LocalConfigDTO getLocalConfig() {
        return this.localConfig;
    }

    public void setLocalConfig(LocalConfigDTO localConfig) {
        this.localConfig = localConfig;
    }

    public ConfigCenterConfigDTO getConfigCenterConfig() {
        return this.configCenterConfig;
    }

    public void setConfigCenterConfig(ConfigCenterConfigDTO configCenterConfig) {
        this.configCenterConfig = configCenterConfig;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public int getRunMode() {
        return this.runMode;
    }

    public void setRunMode(int runMode) {
        this.runMode = runMode;
    }

    public List<String> getPropertiesExtension() {
        return this.propertiesExtension;
    }

    public void setPropertiesExtension(List<String> propertiesExtension) {
        this.propertiesExtension = propertiesExtension;
    }

    public boolean valid() {
        if (1 == this.runMode) {
            if (Objects.isNull(this.localConfig)) {
                logger.error("Local runMode,Config json-localConfig is wrong please check");
                return false;
            }
            if (Strings.isNullOrEmpty(this.localConfig.getPath())) {
                logger.error("Local runMode,Config json-localConfig-path is wrong please check");
                return false;
            }
        } else if (2 == this.runMode) {
            if (Objects.isNull(this.configCenterConfig)) {
                logger.error("Config center runMode,Config json-configCenter is wrong please check");
                return false;
            }
            if (Strings.isNullOrEmpty(this.configCenterConfig.getServerHost())) {
                logger.error("Config center runMode,Config json-configCenter-serverHost is wrong please check");
                return false;
            }
        } else if (3 == this.runMode) {
            if (Objects.isNull(this.localConfig) && Objects.isNull(this.configCenterConfig)) {
                logger.error("Mix runMode,Config json localConfig and configCenter is wrong please check");
                return false;
            }
        } else {
            logger.error("Config json-runMode is wrong please check");
            return false;
        }
        logger.info("loader info project[{}] module[{}] env[{}] region[{}] extSet[{}] runMode[{}]", this.project, this.module, this.env, this.region, this.propertiesExtension, this.runMode);
        logger.info("loader local info path[{}] recursive[{}] refreshInterval[{}]", this.localConfig.getPath(), this.localConfig.getRecursive(), this.localConfig.getRefreshInterval());
        logger.info("loader server info serverHost[{}] localCacheDir[{}] username[{}] password[{}] readTimeout[{}] configLongPollTimeout[{}] configRetryTime[{}] maxRetry[{}] enableRemoteSyncConfig[{}]", this.configCenterConfig.getServerHost(), this.configCenterConfig.getLocalCacheDir(), this.configCenterConfig.getUsername(), this.configCenterConfig.getPassword(), this.configCenterConfig.getReadTimeout(), this.configCenterConfig.getConfigLongPollTimeout(), this.configCenterConfig.getConfigRetryTime(), this.configCenterConfig.getMaxRetry(), this.configCenterConfig.getEnableRemoteSyncConfig());
        return true;
    }
}

