/*
 * Decompiled with CFR 0.152.
 */
package common.log.filter;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class HttpTools {
    private static ImmutableList<String> ipHeaderNameList = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("x-forwarded-for")).add("CF-Connecting-IP")).add("Proxy-Client-IP")).add("WL-Proxy-Client-IP")).add("X-Forwarded-For")).add("HTTP_X_REAL_IP")).add("HTTP_CLIENT_IP")).add("HTTP_X_FORWARDED_FOR")).build();

    private static boolean isInvalidClientIp(String clientIp) {
        if (Strings.isNullOrEmpty(clientIp)) {
            return false;
        }
        return !"unknown".equalsIgnoreCase(clientIp);
    }

    public static String getClientIp(HttpServletRequest request) {
        int pos;
        String headerName;
        String remoteHost = null;
        Iterator iterator2 = ipHeaderNameList.iterator();
        while (iterator2.hasNext() && !HttpTools.isInvalidClientIp(remoteHost = request.getHeader(headerName = (String)iterator2.next()))) {
        }
        if (!HttpTools.isInvalidClientIp(remoteHost)) {
            remoteHost = request.getRemoteAddr();
        }
        if (!Strings.isNullOrEmpty(remoteHost) && (pos = remoteHost.indexOf(",")) > 0) {
            remoteHost = remoteHost.substring(0, pos);
        }
        return Strings.nullToEmpty(remoteHost);
    }

    public static String getParameter(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        if (Strings.isNullOrEmpty(key)) {
            return "";
        }
        return request.getParameter(key);
    }

    public static String getCookie(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        if (Strings.isNullOrEmpty(key)) {
            return "";
        }
        Cookie[] cookies = request.getCookies();
        if (Objects.nonNull(cookies)) {
            for (Cookie cookie : cookies) {
                if (!key.contentEquals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return "";
    }

    public static String getHeader(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        if (Strings.isNullOrEmpty(key)) {
            return "";
        }
        return Strings.nullToEmpty(request.getHeader(key));
    }

    public static String getHttpParameter(HttpServletRequest request, String key) {
        String value = HttpTools.getCookie(request, key);
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        value = HttpTools.getParameter(request, key);
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        value = HttpTools.getHeader(request, key);
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        return "";
    }
}

