/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class CompositeExchangeAttribute
implements ExchangeAttribute {
    private final ExchangeAttribute[] attributes;

    public CompositeExchangeAttribute(ExchangeAttribute[] attributes) {
        ExchangeAttribute[] copy = new ExchangeAttribute[attributes.length];
        System.arraycopy(attributes, 0, copy, 0, attributes.length);
        this.attributes = copy;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            String val = this.attributes[i2].readAttribute(exchange2);
            if (val == null) continue;
            sb.append(val);
        }
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("combined", newValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            sb.append(this.attributes[i2].toString());
        }
        return sb.toString();
    }
}

