/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class HostAndPortAttribute
implements ExchangeAttribute {
    public static final String HOST_AND_PORT = "%{HOST_AND_PORT}";
    public static final ExchangeAttribute INSTANCE = new HostAndPortAttribute();

    private HostAndPortAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        return exchange2.getHostAndPort();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Host and Port", newValue);
    }

    public String toString() {
        return HOST_AND_PORT;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Host and Port";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(HostAndPortAttribute.HOST_AND_PORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

