/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeWrapper;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class QuotingExchangeAttribute
implements ExchangeAttribute {
    private final ExchangeAttribute exchangeAttribute;
    public static final ExchangeAttributeWrapper WRAPPER = new Wrapper();

    public QuotingExchangeAttribute(ExchangeAttribute exchangeAttribute) {
        this.exchangeAttribute = exchangeAttribute;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        String svalue = this.exchangeAttribute.readAttribute(exchange2);
        if (svalue == null || "-".equals(svalue) || svalue.isEmpty()) {
            return "-";
        }
        StringBuilder buffer = new StringBuilder(svalue.length() + 2);
        buffer.append('\'');
        int i2 = 0;
        while (i2 < svalue.length()) {
            int j = svalue.indexOf(39, i2);
            if (j == -1) {
                buffer.append(svalue.substring(i2));
                i2 = svalue.length();
                continue;
            }
            buffer.append(svalue.substring(i2, j + 1));
            buffer.append('\"');
            i2 = j + 2;
        }
        buffer.append('\'');
        return buffer.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException();
    }

    public String toString() {
        return "\"" + this.exchangeAttribute.toString() + "\"";
    }

    public static class Wrapper
    implements ExchangeAttributeWrapper {
        @Override
        public ExchangeAttribute wrap(ExchangeAttribute attribute) {
            return new QuotingExchangeAttribute(attribute);
        }
    }
}

