/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.QueryParameterUtils;

public class RelativePathAttribute
implements ExchangeAttribute {
    public static final String RELATIVE_PATH_SHORT = "%R";
    public static final String RELATIVE_PATH = "%{RELATIVE_PATH}";
    public static final ExchangeAttribute INSTANCE = new RelativePathAttribute();

    private RelativePathAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        return exchange2.getRelativePath();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        int pos = newValue.indexOf(63);
        if (pos == -1) {
            exchange2.setRelativePath(newValue);
            String requestURI = exchange2.getResolvedPath() + newValue;
            if (requestURI.contains("%")) {
                exchange2.setRequestURI(requestURI.replaceAll("%", "%25"));
            } else {
                exchange2.setRequestURI(requestURI);
            }
            exchange2.setRequestPath(requestURI);
        } else {
            String path = newValue.substring(0, pos);
            exchange2.setRelativePath(path);
            String requestURI = exchange2.getResolvedPath() + path;
            if (requestURI.contains("%")) {
                exchange2.setRequestURI(requestURI.replaceAll("%", "%25"));
            } else {
                exchange2.setRequestURI(requestURI);
            }
            exchange2.setRequestPath(requestURI);
            String newQueryString = newValue.substring(pos);
            exchange2.setQueryString(newQueryString);
            exchange2.getQueryParameters().putAll(QueryParameterUtils.parseQueryString(newQueryString.substring(1), QueryParameterUtils.getQueryParamEncoding(exchange2)));
        }
    }

    public String toString() {
        return RELATIVE_PATH;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Relative Path";
        }

        @Override
        public ExchangeAttribute build(String token) {
            return token.equals(RelativePathAttribute.RELATIVE_PATH) || token.equals(RelativePathAttribute.RELATIVE_PATH_SHORT) ? INSTANCE : null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

