/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.NetworkUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class RemoteObfuscatedIPAttribute
implements ExchangeAttribute {
    public static final String REMOTE_OBFUSCATED_IP_SHORT = "%o";
    public static final String REMOTE_OBFUSCATED_IP = "%{REMOTE_OBFUSCATED_IP}";
    public static final ExchangeAttribute INSTANCE = new RemoteObfuscatedIPAttribute();

    private RemoteObfuscatedIPAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        InetSocketAddress sourceAddress = exchange2.getSourceAddress();
        InetAddress address = sourceAddress.getAddress();
        if (address == null) {
            address = ((InetSocketAddress)exchange2.getConnection().getPeerAddress()).getAddress();
        }
        if (address == null) {
            return null;
        }
        return NetworkUtils.toObfuscatedString(address);
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Remote Obfuscated IP", newValue);
    }

    public String toString() {
        return REMOTE_OBFUSCATED_IP;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Remote Obfuscated IP";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RemoteObfuscatedIPAttribute.REMOTE_OBFUSCATED_IP) || token.equals(RemoteObfuscatedIPAttribute.REMOTE_OBFUSCATED_IP_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

