/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class ResponseCodeAttribute
implements ExchangeAttribute {
    public static final String RESPONSE_CODE_SHORT = "%s";
    public static final String RESPONSE_CODE = "%{RESPONSE_CODE}";
    public static final ExchangeAttribute INSTANCE = new ResponseCodeAttribute();

    private ResponseCodeAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        return Integer.toString(exchange2.getStatusCode());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        exchange2.setStatusCode(Integer.parseInt(newValue));
    }

    public String toString() {
        return RESPONSE_CODE;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response code";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ResponseCodeAttribute.RESPONSE_CODE) || token.equals(ResponseCodeAttribute.RESPONSE_CODE_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

