/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class DebuggingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final List<byte[]> data = new CopyOnWriteArrayList<byte[]>();

    public DebuggingStreamSinkConduit(StreamSinkConduit next) {
        super(next);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int pos = src.position();
        int res = super.write(src);
        if (res > 0) {
            byte[] d = new byte[res];
            for (int i2 = 0; i2 < res; ++i2) {
                d[i2] = src.get(i2 + pos);
            }
            data.add(d);
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] dsts, int offs, int len) throws IOException {
        for (int i2 = offs; i2 < len; ++i2) {
            if (!dsts[i2].hasRemaining()) continue;
            return this.write(dsts[i2]);
        }
        return 0L;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source2, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    public static void dump() {
        for (int i2 = 0; i2 < data.size(); ++i2) {
            System.out.println("Write Buffer " + i2);
            StringBuilder sb = new StringBuilder();
            try {
                Buffers.dump(ByteBuffer.wrap(data.get(i2)), (Appendable)sb, 0, 20);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            System.out.println(sb);
            System.out.println();
        }
    }
}

