/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.conduits.ConduitListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public final class HeadStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final ConduitListener<? super HeadStreamSinkConduit> finishListener;
    private int state;
    private final boolean shutdownDelegate;
    private static final int FLAG_CLOSE_REQUESTED = 1;
    private static final int FLAG_CLOSE_COMPLETE = 2;
    private static final int FLAG_FINISHED_CALLED = 4;

    public HeadStreamSinkConduit(StreamSinkConduit next, ConduitListener<? super HeadStreamSinkConduit> finishListener) {
        this(next, finishListener, false);
    }

    public HeadStreamSinkConduit(StreamSinkConduit next, ConduitListener<? super HeadStreamSinkConduit> finishListener, boolean shutdownDelegate) {
        super(next);
        this.finishListener = finishListener;
        this.shutdownDelegate = shutdownDelegate;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw new ClosedChannelException();
        }
        int remaining = src.remaining();
        src.position(src.position() + remaining);
        return remaining;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw new ClosedChannelException();
        }
        long total = 0L;
        for (int i2 = offset; i2 < offset + length; ++i2) {
            ByteBuffer src = srcs[i2];
            int remaining = src.remaining();
            total += (long)remaining;
            src.position(src.position() + remaining);
        }
        return total;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer(source2, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        int val = this.state;
        if (Bits.anyAreSet(val, 2)) {
            return true;
        }
        boolean flushed = false;
        try {
            boolean bl = flushed = ((StreamSinkConduit)this.next).flush();
            return bl;
        }
        finally {
            this.exitFlush(val, flushed);
        }
    }

    @Override
    public void suspendWrites() {
        long val = this.state;
        if (Bits.anyAreSet(val, 2L)) {
            return;
        }
        ((StreamSinkConduit)this.next).suspendWrites();
    }

    @Override
    public void resumeWrites() {
        long val = this.state;
        if (Bits.anyAreSet(val, 2L)) {
            return;
        }
        ((StreamSinkConduit)this.next).resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return Bits.allAreClear(this.state, 2) && ((StreamSinkConduit)this.next).isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        long val = this.state;
        if (Bits.anyAreSet(val, 2L)) {
            return;
        }
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    @Override
    public void terminateWrites() throws IOException {
        int newVal;
        int oldVal = this.state;
        if (Bits.anyAreSet(oldVal, 3)) {
            return;
        }
        this.state = newVal = oldVal | 1;
        if (this.shutdownDelegate) {
            ((StreamSinkConduit)this.next).terminateWrites();
        }
    }

    private void exitFlush(int oldVal, boolean flushed) {
        int newVal = oldVal;
        boolean callFinish = false;
        if (Bits.anyAreSet(oldVal, 1) && flushed) {
            newVal |= 2;
            if (!Bits.anyAreSet(oldVal, 4)) {
                newVal |= 4;
                callFinish = true;
            }
            this.state = newVal;
            if (callFinish && this.finishListener != null) {
                this.finishListener.handleEvent(this);
            }
        }
    }
}

