/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MethodPredicate
implements Predicate {
    private final HttpString[] methods;

    MethodPredicate(String[] methods) {
        HttpString[] values2 = new HttpString[methods.length];
        for (int i2 = 0; i2 < methods.length; ++i2) {
            values2[i2] = HttpString.tryFromString(methods[i2]);
        }
        this.methods = values2;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        for (int i2 = 0; i2 < this.methods.length; ++i2) {
            if (!value.getRequestMethod().equals(this.methods[i2])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.methods.length == 1) {
            return "method( '" + this.methods[0] + "' )";
        }
        return "method( {" + Arrays.asList(this.methods).stream().map(s2 -> s2.toString()).collect(Collectors.joining(", ")) + "} )";
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "method";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("value", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] methods = (String[])config.get("value");
            return new MethodPredicate(methods);
        }
    }
}

