/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.UndertowMessages;
import java.io.ByteArrayOutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;

final class ALPNHackClientHelloExplorer {
    public static final int RECORD_HEADER_SIZE = 5;

    private ALPNHackClientHelloExplorer() {
    }

    static List<String> exploreClientHello(ByteBuffer source2) throws SSLException {
        ByteBuffer input = source2.duplicate();
        if (input.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        ArrayList<String> alpnProtocols = new ArrayList<String>();
        byte firstByte = input.get();
        byte secondByte = input.get();
        byte thirdByte = input.get();
        if ((firstByte & 0x80) != 0 && thirdByte == 1) {
            return null;
        }
        if (firstByte == 22) {
            if (secondByte == 3 && thirdByte >= 1 && thirdByte <= 3) {
                ALPNHackClientHelloExplorer.exploreTLSRecord(input, firstByte, secondByte, thirdByte, alpnProtocols, null);
                return alpnProtocols;
            }
            return null;
        }
        throw UndertowMessages.MESSAGES.notHandshakeRecord();
    }

    static byte[] rewriteClientHello(byte[] source2, List<String> alpnProtocols) throws SSLException {
        ByteBuffer input = ByteBuffer.wrap(source2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (input.remaining() < 5) {
            throw new BufferUnderflowException();
        }
        try {
            byte firstByte = input.get();
            byte secondByte = input.get();
            byte thirdByte = input.get();
            out.write(firstByte & 0xFF);
            out.write(secondByte & 0xFF);
            out.write(thirdByte & 0xFF);
            if ((firstByte & 0x80) != 0 && thirdByte == 1) {
                return null;
            }
            if (firstByte == 22) {
                if (secondByte == 3 && thirdByte == 3) {
                    ALPNHackClientHelloExplorer.exploreTLSRecord(input, firstByte, secondByte, thirdByte, alpnProtocols, out);
                    int clientHelloLength = out.size() - 9;
                    byte[] data = out.toByteArray();
                    int newLength = data.length - 5;
                    data[3] = (byte)(newLength >> 8 & 0xFF);
                    data[4] = (byte)(newLength & 0xFF);
                    data[6] = (byte)(clientHelloLength >> 16 & 0xFF);
                    data[7] = (byte)(clientHelloLength >> 8 & 0xFF);
                    data[8] = (byte)(clientHelloLength & 0xFF);
                    return data;
                }
                return null;
            }
            throw UndertowMessages.MESSAGES.notHandshakeRecord();
        }
        catch (ALPNPresentException e) {
            return null;
        }
    }

    private static void exploreTLSRecord(ByteBuffer input, byte firstByte, byte secondByte, byte thirdByte, List<String> alpnProtocols, ByteArrayOutputStream out) throws SSLException {
        if (firstByte != 22) {
            throw UndertowMessages.MESSAGES.notHandshakeRecord();
        }
        int recordLength = ALPNHackClientHelloExplorer.getInt16(input);
        if (recordLength > input.remaining()) {
            throw new BufferUnderflowException();
        }
        if (out != null) {
            out.write(0);
            out.write(0);
        }
        try {
            ALPNHackClientHelloExplorer.exploreHandshake(input, secondByte, thirdByte, recordLength, alpnProtocols, out);
        }
        catch (BufferUnderflowException ignored) {
            throw UndertowMessages.MESSAGES.invalidHandshakeRecord();
        }
    }

    private static void exploreHandshake(ByteBuffer input, byte recordMajorVersion, byte recordMinorVersion, int recordLength, List<String> alpnProtocols, ByteArrayOutputStream out) throws SSLException {
        byte handshakeType = input.get();
        if (handshakeType != 1) {
            throw UndertowMessages.MESSAGES.expectedClientHello();
        }
        if (out != null) {
            out.write(handshakeType & 0xFF);
        }
        int handshakeLength = ALPNHackClientHelloExplorer.getInt24(input);
        if (out != null) {
            out.write(0);
            out.write(0);
            out.write(0);
        }
        if (handshakeLength > recordLength - 4) {
            throw UndertowMessages.MESSAGES.multiRecordSSLHandshake();
        }
        input = input.duplicate();
        input.limit(handshakeLength + input.position());
        ALPNHackClientHelloExplorer.exploreClientHello(input, alpnProtocols, out);
    }

    private static void exploreClientHello(ByteBuffer input, List<String> alpnProtocols, ByteArrayOutputStream out) throws SSLException {
        byte helloMajorVersion = input.get();
        byte helloMinorVersion = input.get();
        if (out != null) {
            out.write(helloMajorVersion & 0xFF);
            out.write(helloMinorVersion & 0xFF);
        }
        if (helloMajorVersion != 3 && helloMinorVersion != 3) {
            return;
        }
        for (int i2 = 0; i2 < 32; ++i2) {
            byte d = input.get();
            if (out == null) continue;
            out.write(d & 0xFF);
        }
        ALPNHackClientHelloExplorer.processByteVector8(input, out);
        ALPNHackClientHelloExplorer.processByteVector16(input, out);
        ALPNHackClientHelloExplorer.processByteVector8(input, out);
        if (input.remaining() > 0) {
            ALPNHackClientHelloExplorer.exploreExtensions(input, alpnProtocols, out);
        } else if (out != null) {
            byte[] data = ALPNHackClientHelloExplorer.generateAlpnExtension(alpnProtocols);
            ALPNHackClientHelloExplorer.writeInt16(out, data.length);
            out.write(data, 0, data.length);
        }
    }

    private static void writeInt16(ByteArrayOutputStream out, int l) {
        if (out == null) {
            return;
        }
        out.write(l >> 8 & 0xFF);
        out.write(l & 0xFF);
    }

    private static byte[] generateAlpnExtension(List<String> alpnProtocols) {
        ByteArrayOutputStream alpnBits = new ByteArrayOutputStream();
        alpnBits.write(0);
        alpnBits.write(16);
        int length = 2;
        for (String p : alpnProtocols) {
            ++length;
            length += p.length();
        }
        ALPNHackClientHelloExplorer.writeInt16(alpnBits, length);
        ALPNHackClientHelloExplorer.writeInt16(alpnBits, length -= 2);
        for (String p : alpnProtocols) {
            alpnBits.write(p.length() & 0xFF);
            for (int i2 = 0; i2 < p.length(); ++i2) {
                alpnBits.write(p.charAt(i2) & 0xFF);
            }
        }
        return alpnBits.toByteArray();
    }

    private static void exploreExtensions(ByteBuffer input, List<String> alpnProtocols, ByteArrayOutputStream out) throws SSLException {
        int extLen;
        ByteArrayOutputStream extensionOut = out == null ? null : new ByteArrayOutputStream();
        ALPNHackClientHelloExplorer.writeInt16(extensionOut, 0);
        for (int length = ALPNHackClientHelloExplorer.getInt16(input); length > 0; length -= extLen + 4) {
            int extType = ALPNHackClientHelloExplorer.getInt16(input);
            ALPNHackClientHelloExplorer.writeInt16(extensionOut, extType);
            extLen = ALPNHackClientHelloExplorer.getInt16(input);
            ALPNHackClientHelloExplorer.writeInt16(extensionOut, extLen);
            if (extType == 16) {
                if (out == null) {
                    ALPNHackClientHelloExplorer.exploreALPNExt(input, alpnProtocols);
                    continue;
                }
                throw new ALPNPresentException();
            }
            ALPNHackClientHelloExplorer.processByteVector(input, extLen, extensionOut);
        }
        if (out != null) {
            byte[] alpnBits = ALPNHackClientHelloExplorer.generateAlpnExtension(alpnProtocols);
            extensionOut.write(alpnBits, 0, alpnBits.length);
            byte[] extensionsData = extensionOut.toByteArray();
            int newLength = extensionsData.length - 2;
            extensionsData[0] = (byte)(newLength >> 8 & 0xFF);
            extensionsData[1] = (byte)(newLength & 0xFF);
            out.write(extensionsData, 0, extensionsData.length);
        }
    }

    private static void exploreALPNExt(ByteBuffer input, List<String> alpnProtocols) {
        int length = ALPNHackClientHelloExplorer.getInt16(input);
        int end = input.position() + length;
        while (input.position() < end) {
            alpnProtocols.add(ALPNHackClientHelloExplorer.readByteVector8(input));
        }
    }

    private static int getInt8(ByteBuffer input) {
        return input.get();
    }

    private static int getInt16(ByteBuffer input) {
        return (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static int getInt24(ByteBuffer input) {
        return (input.get() & 0xFF) << 16 | (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static void processByteVector8(ByteBuffer input, ByteArrayOutputStream out) {
        int int8 = ALPNHackClientHelloExplorer.getInt8(input);
        if (out != null) {
            out.write(int8 & 0xFF);
        }
        ALPNHackClientHelloExplorer.processByteVector(input, int8, out);
    }

    private static void processByteVector(ByteBuffer input, int length, ByteArrayOutputStream out) {
        for (int i2 = 0; i2 < length; ++i2) {
            byte b = input.get();
            if (out == null) continue;
            out.write(b & 0xFF);
        }
    }

    private static String readByteVector8(ByteBuffer input) {
        int length = ALPNHackClientHelloExplorer.getInt8(input);
        byte[] data = new byte[length];
        input.get(data);
        return new String(data, StandardCharsets.US_ASCII);
    }

    private static void processByteVector16(ByteBuffer input, ByteArrayOutputStream out) {
        int int16 = ALPNHackClientHelloExplorer.getInt16(input);
        ALPNHackClientHelloExplorer.writeInt16(out, int16);
        ALPNHackClientHelloExplorer.processByteVector(input, int16, out);
    }

    private static final class ALPNPresentException
    extends RuntimeException {
        private ALPNPresentException() {
        }
    }
}

