/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.handlers.AbstractConfidentialityHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.NetworkUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class SinglePortConfidentialityHandler
extends AbstractConfidentialityHandler {
    private final int redirectPort;

    public SinglePortConfidentialityHandler(HttpHandler next, int redirectPort) {
        super(next);
        this.redirectPort = redirectPort == 443 ? -1 : redirectPort;
    }

    @Override
    protected URI getRedirectURI(HttpServerExchange exchange2) throws URISyntaxException {
        return this.getRedirectURI(exchange2, this.redirectPort);
    }

    protected URI getRedirectURI(HttpServerExchange exchange2, int port) throws URISyntaxException {
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append("https://");
        uriBuilder.append(NetworkUtils.formatPossibleIpv6Address(exchange2.getHostName()));
        if (port > 0) {
            uriBuilder.append(":").append(port);
        }
        String uri = exchange2.getRequestURI();
        if (exchange2.isHostIncludedInRequestURI()) {
            int slashCount = 0;
            for (int i2 = 0; i2 < uri.length(); ++i2) {
                if (uri.charAt(i2) != '/' || ++slashCount != 3) continue;
                uri = uri.substring(i2);
                break;
            }
        }
        uriBuilder.append(uri);
        String queryString = exchange2.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            uriBuilder.append("?").append(queryString);
        }
        return new URI(uriBuilder.toString());
    }
}

