/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowOptions;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.AttachmentKey;
import io.undertow.util.PathTemplateMatch;
import io.undertow.util.URLUtils;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class URLDecodingHandler
implements HttpHandler {
    private static final ThreadLocal<StringBuilder> DECODING_BUFFER_CACHE = ThreadLocal.withInitial(StringBuilder::new);
    private static final AttachmentKey<Object> ALREADY_DECODED = AttachmentKey.create(Object.class);
    private final HttpHandler next;
    private final String charset;

    public URLDecodingHandler(HttpHandler next, String charset) {
        this.next = next;
        this.charset = charset;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        if (URLDecodingHandler.shouldDecode(exchange2)) {
            StringBuilder sb = URLDecodingHandler.getStringBuilderForDecoding(exchange2);
            URLDecodingHandler.decodePath(exchange2, this.charset, sb);
            URLDecodingHandler.decodeQueryString(exchange2, this.charset, sb);
            URLDecodingHandler.decodePathTemplateMatch(exchange2, this.charset, sb);
        }
        this.next.handleRequest(exchange2);
    }

    private static boolean shouldDecode(HttpServerExchange exchange2) {
        return !exchange2.getConnection().getUndertowOptions().get(UndertowOptions.DECODE_URL, true) && exchange2.putAttachment(ALREADY_DECODED, Boolean.TRUE) == null;
    }

    private static void decodePath(HttpServerExchange exchange2, String charset, StringBuilder sb) {
        boolean decodeSlash = exchange2.getConnection().getUndertowOptions().get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
        exchange2.setRequestPath(URLUtils.decode(exchange2.getRequestPath(), charset, decodeSlash, false, sb));
        exchange2.setRelativePath(URLUtils.decode(exchange2.getRelativePath(), charset, decodeSlash, false, sb));
        exchange2.setResolvedPath(URLUtils.decode(exchange2.getResolvedPath(), charset, decodeSlash, false, sb));
    }

    private static void decodeQueryString(HttpServerExchange exchange2, String charset, StringBuilder sb) {
        if (!exchange2.getQueryString().isEmpty()) {
            TreeMap newParams = new TreeMap();
            for (Map.Entry<String, Deque<String>> param : exchange2.getQueryParameters().entrySet()) {
                ArrayDeque<String> newValues = new ArrayDeque<String>(param.getValue().size());
                for (String val : param.getValue()) {
                    newValues.add(URLUtils.decode(val, charset, true, true, sb));
                }
                newParams.put(URLUtils.decode(param.getKey(), charset, true, true, sb), newValues);
            }
            exchange2.getQueryParameters().clear();
            exchange2.getQueryParameters().putAll(newParams);
        }
    }

    private static void decodePathTemplateMatch(HttpServerExchange exchange2, String charset, StringBuilder sb) {
        Map<String, String> parameters;
        PathTemplateMatch pathTemplateMatch = exchange2.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
        if (pathTemplateMatch != null && (parameters = pathTemplateMatch.getParameters()) != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                entry.setValue(URLUtils.decode(entry.getValue(), charset, true, false, sb));
            }
        }
    }

    private static StringBuilder getStringBuilderForDecoding(HttpServerExchange exchange2) {
        if (exchange2.isInIoThread()) {
            return DECODING_BUFFER_CACHE.get();
        }
        return new StringBuilder();
    }

    public String toString() {
        return "url-decoding( " + this.charset + " )";
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String charset;

        private Wrapper(String charset) {
            this.charset = charset;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new URLDecodingHandler(handler, this.charset);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "url-decoding";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("charset", String.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("charset");
        }

        @Override
        public String defaultParameter() {
            return "charset";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper(config.get("charset").toString());
        }
    }
}

