/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.xnio.Buffers;

public class ResponseCachingSender
implements Sender {
    private final Sender delegate;
    private final DirectBufferCache.CacheEntry cacheEntry;
    private final long length;
    private long written;

    public ResponseCachingSender(Sender delegate, DirectBufferCache.CacheEntry cacheEntry, long length) {
        this.delegate = delegate;
        this.cacheEntry = cacheEntry;
        this.length = length;
    }

    @Override
    public void send(ByteBuffer src, IoCallback callback) {
        ByteBuffer origSrc = src.duplicate();
        this.handleUpdate(origSrc);
        this.delegate.send(src, callback);
    }

    @Override
    public void send(ByteBuffer[] srcs, IoCallback callback) {
        ByteBuffer[] origSrc = new ByteBuffer[srcs.length];
        long total = 0L;
        for (int i2 = 0; i2 < srcs.length; ++i2) {
            origSrc[i2] = srcs[i2].duplicate();
            total += (long)origSrc[i2].remaining();
        }
        this.handleUpdate(origSrc, total);
        this.delegate.send(srcs, callback);
    }

    @Override
    public void send(ByteBuffer src) {
        ByteBuffer origSrc = src.duplicate();
        this.handleUpdate(origSrc);
        this.delegate.send(src);
    }

    @Override
    public void send(ByteBuffer[] srcs) {
        ByteBuffer[] origSrc = new ByteBuffer[srcs.length];
        long total = 0L;
        for (int i2 = 0; i2 < srcs.length; ++i2) {
            origSrc[i2] = srcs[i2].duplicate();
            total += (long)origSrc[i2].remaining();
        }
        this.handleUpdate(origSrc, total);
        this.delegate.send(srcs);
    }

    @Override
    public void send(String data, IoCallback callback) {
        this.handleUpdate(ByteBuffer.wrap(data.getBytes(StandardCharsets.UTF_8)));
        this.delegate.send(data, callback);
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        this.handleUpdate(ByteBuffer.wrap(data.getBytes(charset)));
        this.delegate.send(data, charset, callback);
    }

    @Override
    public void send(String data) {
        this.handleUpdate(ByteBuffer.wrap(data.getBytes(StandardCharsets.UTF_8)));
        this.delegate.send(data);
    }

    @Override
    public void send(String data, Charset charset) {
        this.handleUpdate(ByteBuffer.wrap(data.getBytes(charset)));
        this.delegate.send(data, charset);
    }

    @Override
    public void transferFrom(FileChannel channel, IoCallback callback) {
        this.delegate.transferFrom(channel, callback);
    }

    @Override
    public void close(IoCallback callback) {
        if (this.written != this.length) {
            this.cacheEntry.disable();
            this.cacheEntry.dereference();
        }
        this.delegate.close();
    }

    @Override
    public void close() {
        if (this.written != this.length) {
            this.cacheEntry.disable();
            this.cacheEntry.dereference();
        }
        this.delegate.close();
    }

    private void handleUpdate(ByteBuffer origSrc) {
        LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
        ByteBuffer[] buffers = new ByteBuffer[pooled.length];
        for (int i2 = 0; i2 < buffers.length; ++i2) {
            buffers[i2] = pooled[i2].getBuffer();
        }
        this.written += (long)Buffers.copy(buffers, 0, buffers.length, origSrc);
        if (this.written == this.length) {
            for (ByteBuffer buffer : buffers) {
                buffer.flip();
            }
            this.cacheEntry.enable();
        }
    }

    private void handleUpdate(ByteBuffer[] origSrc, long totalWritten) {
        LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
        ByteBuffer[] buffers = new ByteBuffer[pooled.length];
        for (int i2 = 0; i2 < buffers.length; ++i2) {
            buffers[i2] = pooled[i2].getBuffer();
        }
        long leftToCopy = totalWritten;
        for (int i3 = 0; i3 < origSrc.length; ++i3) {
            ByteBuffer buf = origSrc[i3];
            if ((long)buf.remaining() > leftToCopy) {
                buf.limit((int)((long)buf.position() + leftToCopy));
            }
            Buffers.copy(buffers, 0, buffers.length, buf);
            if ((leftToCopy -= (long)buf.remaining()) == 0L) break;
        }
        this.written += totalWritten;
        if (this.written == this.length) {
            for (ByteBuffer buffer : buffers) {
                buffer.flip();
            }
            this.cacheEntry.enable();
        }
    }
}

