/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.client.ClientConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.ExclusivityChecker;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterProxyTarget;
import io.undertow.util.AttachmentKey;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.xnio.IoUtils;

class ModClusterProxyClient
implements ProxyClient {
    private final AttachmentKey<ExclusiveConnectionHolder> exclusiveConnectionKey = AttachmentKey.create(ExclusiveConnectionHolder.class);
    private final ExclusivityChecker exclusivityChecker;
    private final ModClusterContainer container;

    protected ModClusterProxyClient(ExclusivityChecker exclusivityChecker, ModClusterContainer container) {
        this.exclusivityChecker = exclusivityChecker;
        this.container = container;
    }

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange exchange2) {
        return this.container.findTarget(exchange2);
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange2, final ProxyCallback<ProxyConnection> callback, long timeout2, TimeUnit timeUnit) {
        final ExclusiveConnectionHolder holder = exchange2.getConnection().getAttachment(this.exclusiveConnectionKey);
        if (holder != null && holder.connection.getConnection().isOpen()) {
            callback.completed(exchange2, holder.connection);
            return;
        }
        if (!(target instanceof ModClusterProxyTarget)) {
            callback.couldNotResolveBackend(exchange2);
            return;
        }
        ModClusterProxyTarget proxyTarget = (ModClusterProxyTarget)target;
        Context context = proxyTarget.resolveContext(exchange2);
        if (context == null) {
            callback.couldNotResolveBackend(exchange2);
        } else if (holder != null || this.exclusivityChecker != null && this.exclusivityChecker.isExclusivityRequired(exchange2)) {
            ProxyCallback<ProxyConnection> wrappedCallback = new ProxyCallback<ProxyConnection>(){

                @Override
                public void completed(HttpServerExchange exchange2, ProxyConnection result) {
                    if (holder != null) {
                        holder.connection = result;
                    } else {
                        final ExclusiveConnectionHolder newHolder = new ExclusiveConnectionHolder();
                        newHolder.connection = result;
                        ServerConnection connection = exchange2.getConnection();
                        connection.putAttachment(ModClusterProxyClient.this.exclusiveConnectionKey, newHolder);
                        connection.addCloseListener(new ServerConnection.CloseListener(){

                            @Override
                            public void closed(ServerConnection connection) {
                                ClientConnection clientConnection = newHolder.connection.getConnection();
                                if (clientConnection.isOpen()) {
                                    IoUtils.safeClose((Closeable)clientConnection);
                                }
                            }
                        });
                    }
                    callback.completed(exchange2, result);
                }

                @Override
                public void queuedRequestFailed(HttpServerExchange exchange2) {
                    callback.queuedRequestFailed(exchange2);
                }

                @Override
                public void failed(HttpServerExchange exchange2) {
                    callback.failed(exchange2);
                }

                @Override
                public void couldNotResolveBackend(HttpServerExchange exchange2) {
                    callback.couldNotResolveBackend(exchange2);
                }
            };
            context.handleRequest(proxyTarget, exchange2, wrappedCallback, timeout2, timeUnit, true);
        } else {
            context.handleRequest(proxyTarget, exchange2, callback, timeout2, timeUnit, false);
        }
    }

    private static class ExclusiveConnectionHolder {
        private ProxyConnection connection;

        private ExclusiveConnectionHolder() {
        }
    }
}

