/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.ETag;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.MimeMappings;
import io.undertow.util.QValueParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PreCompressedResourceSupplier
implements ResourceSupplier {
    private final ResourceManager resourceManager;
    private final Map<String, String> encodingMap = new CopyOnWriteMap<String, String>();

    public PreCompressedResourceSupplier(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public Resource getResource(HttpServerExchange exchange2, String path) throws IOException {
        Resource originalResource = this.resourceManager.getResource(path);
        if (exchange2.getRequestHeaders().contains(Headers.RANGE)) {
            return originalResource;
        }
        Resource resource = this.getEncodedResource(exchange2, path, originalResource);
        if (resource == null) {
            return originalResource;
        }
        return resource;
    }

    private Resource getEncodedResource(HttpServerExchange exchange2, String path, final Resource originalResource) throws IOException {
        HeaderValues res = exchange2.getRequestHeaders().get(Headers.ACCEPT_ENCODING);
        if (res == null || res.isEmpty()) {
            return null;
        }
        List<List<QValueParser.QValueResult>> found = QValueParser.parse(res);
        for (List<QValueParser.QValueResult> result : found) {
            for (final QValueParser.QValueResult value : result) {
                String newPath;
                Resource resource;
                String extension = this.encodingMap.get(value.getValue());
                if (extension == null || (resource = this.resourceManager.getResource(newPath = path + extension)) == null || resource.isDirectory()) continue;
                return new Resource(){

                    @Override
                    public String getPath() {
                        return resource.getPath();
                    }

                    @Override
                    public Date getLastModified() {
                        return resource.getLastModified();
                    }

                    @Override
                    public String getLastModifiedString() {
                        return resource.getLastModifiedString();
                    }

                    @Override
                    public ETag getETag() {
                        return resource.getETag();
                    }

                    @Override
                    public String getName() {
                        return resource.getName();
                    }

                    @Override
                    public boolean isDirectory() {
                        return false;
                    }

                    @Override
                    public List<Resource> list() {
                        return resource.list();
                    }

                    @Override
                    public String getContentType(MimeMappings mimeMappings) {
                        return originalResource.getContentType(mimeMappings);
                    }

                    @Override
                    public void serve(Sender sender, HttpServerExchange exchange2, IoCallback completionCallback) {
                        exchange2.getResponseHeaders().put(Headers.CONTENT_ENCODING, value.getValue());
                        resource.serve(sender, exchange2, completionCallback);
                    }

                    @Override
                    public Long getContentLength() {
                        return resource.getContentLength();
                    }

                    @Override
                    public String getCacheKey() {
                        return resource.getCacheKey();
                    }

                    @Override
                    public File getFile() {
                        return resource.getFile();
                    }

                    @Override
                    public Path getFilePath() {
                        return resource.getFilePath();
                    }

                    @Override
                    public File getResourceManagerRoot() {
                        return resource.getResourceManagerRoot();
                    }

                    @Override
                    public Path getResourceManagerRootPath() {
                        return resource.getResourceManagerRootPath();
                    }

                    @Override
                    public URL getUrl() {
                        return resource.getUrl();
                    }
                };
            }
        }
        return null;
    }

    public PreCompressedResourceSupplier addEncoding(String encoding, String extension) {
        this.encodingMap.put(encoding, extension);
        return this;
    }

    public PreCompressedResourceSupplier removeEncoding(String encoding) {
        this.encodingMap.remove(encoding);
        return this;
    }
}

