/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.sse;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.PathTemplateMatch;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

public class ServerSentEventHandler
implements HttpHandler {
    private static final HttpString LAST_EVENT_ID = new HttpString("Last-Event-ID");
    private final ServerSentEventConnectionCallback callback;
    private final Set<ServerSentEventConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());

    public ServerSentEventHandler(ServerSentEventConnectionCallback callback) {
        this.callback = callback;
    }

    public ServerSentEventHandler() {
        this.callback = null;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange2) throws Exception {
        exchange2.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/event-stream; charset=UTF-8");
        exchange2.setPersistent(false);
        final StreamSinkChannel sink2 = exchange2.getResponseChannel();
        if (!sink2.flush()) {
            sink2.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                @Override
                public void handleEvent(StreamSinkChannel channel) {
                    ServerSentEventHandler.this.handleConnect(channel, exchange2);
                }
            }, new ChannelExceptionHandler<StreamSinkChannel>(){

                @Override
                public void handleException(StreamSinkChannel channel, IOException exception) {
                    IoUtils.safeClose((Closeable)exchange2.getConnection());
                }
            }));
            sink2.resumeWrites();
        } else {
            exchange2.dispatch((Executor)exchange2.getIoThread(), new Runnable(){

                @Override
                public void run() {
                    ServerSentEventHandler.this.handleConnect(sink2, exchange2);
                }
            });
        }
    }

    private void handleConnect(StreamSinkChannel channel, HttpServerExchange exchange2) {
        UndertowLogger.REQUEST_LOGGER.debugf("Opened SSE connection to %s", (Object)exchange2);
        final ServerSentEventConnection connection = new ServerSentEventConnection(exchange2, channel);
        PathTemplateMatch pt = exchange2.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
        if (pt != null) {
            for (Map.Entry<String, String> p : pt.getParameters().entrySet()) {
                connection.setParameter(p.getKey(), p.getValue());
            }
        }
        this.connections.add(connection);
        connection.addCloseTask(new ChannelListener<ServerSentEventConnection>(){

            @Override
            public void handleEvent(ServerSentEventConnection channel) {
                ServerSentEventHandler.this.connections.remove(connection);
            }
        });
        if (this.callback != null) {
            this.callback.connected(connection, exchange2.getRequestHeaders().getLast(LAST_EVENT_ID));
        }
    }

    public Set<ServerSentEventConnection> getConnections() {
        return Collections.unmodifiableSet(this.connections);
    }
}

