/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;

public class ServletContextAttribute
implements ExchangeAttribute {
    private final String attributeName;

    public ServletContextAttribute(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        Object result;
        ServletRequestContext context = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null && (result = context.getCurrentServletContext().getAttribute(this.attributeName)) != null) {
            return result.toString();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        ServletRequestContext context = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null) {
            context.getCurrentServletContext().setAttribute(this.attributeName, newValue);
        }
    }

    public String toString() {
        return "%{sc," + this.attributeName + "}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Servlet context attribute";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{sc,") && token.endsWith("}")) {
                String attributeName = token.substring(5, token.length() - 1);
                return new ServletContextAttribute(attributeName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

