/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.attribute.RequestLineAttribute;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.attribute.ServletRequestURLAttribute;
import io.undertow.servlet.handlers.ServletRequestContext;

public class ServletRequestLineAttribute
implements ExchangeAttribute {
    public static final String REQUEST_LINE_SHORT = "%r";
    public static final String REQUEST_LINE = "%{REQUEST_LINE}";
    public static final ExchangeAttribute INSTANCE = new ServletRequestLineAttribute();

    private ServletRequestLineAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        ServletRequestContext src = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (src == null) {
            return RequestLineAttribute.INSTANCE.readAttribute(exchange2);
        }
        StringBuilder sb = new StringBuilder().append(exchange2.getRequestMethod().toString()).append(' ').append(ServletRequestURLAttribute.INSTANCE.readAttribute(exchange2));
        String query = (String)src.getServletRequest().getAttribute("javax.servlet.forward.query_string");
        if (query != null && !query.isEmpty()) {
            sb.append('?');
            sb.append(query);
        } else if (!exchange2.getQueryString().isEmpty()) {
            sb.append('?');
            sb.append(exchange2.getQueryString());
        }
        sb.append(' ').append(exchange2.getProtocol().toString()).toString();
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Request line", newValue);
    }

    public String toString() {
        return REQUEST_LINE;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request line";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ServletRequestLineAttribute.REQUEST_LINE) || token.equals(ServletRequestLineAttribute.REQUEST_LINE_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 1;
        }
    }
}

