/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

public class ServletHandler
implements HttpHandler {
    private final ManagedServlet managedServlet;

    public ServletHandler(ManagedServlet managedServlet) {
        this.managedServlet = managedServlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(HttpServerExchange exchange2) throws IOException, ServletException {
        if (this.managedServlet.isPermanentlyUnavailable()) {
            UndertowServletLogger.REQUEST_LOGGER.debugf("Returning 404 for servlet %s due to permanent unavailability", (Object)this.managedServlet.getServletInfo().getName());
            exchange2.setStatusCode(404);
            return;
        }
        if (this.managedServlet.isTemporarilyUnavailable()) {
            UndertowServletLogger.REQUEST_LOGGER.debugf("Returning 503 for servlet %s due to temporary unavailability", (Object)this.managedServlet.getServletInfo().getName());
            exchange2.setStatusCode(503);
            return;
        }
        ServletRequestContext servletRequestContext = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (!this.managedServlet.getServletInfo().isAsyncSupported()) {
            servletRequestContext.setAsyncSupported(false);
        }
        ServletRequest request = servletRequestContext.getServletRequest();
        ServletResponse response = servletRequestContext.getServletResponse();
        InstanceHandle<? extends Servlet> servlet = null;
        try {
            servlet = this.managedServlet.getServlet();
            servlet.getInstance().service(request, response);
        }
        catch (UnavailableException e) {
            this.managedServlet.handleUnavailableException(e);
            if (e.isPermanent()) {
                exchange2.setStatusCode(404);
            } else {
                exchange2.setStatusCode(503);
            }
        }
        finally {
            if (servlet != null) {
                servlet.release();
            }
        }
    }

    public ManagedServlet getManagedServlet() {
        return this.managedServlet;
    }
}

