/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.ServerConnection;
import io.undertow.server.XnioBufferPoolAdaptor;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.LoggingExceptionHandler;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.ServletBlockingHttpExchange;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletDebugPageHandler;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ConnectedChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;

public class ServletInitialHandler
implements HttpHandler,
ServletDispatcher {
    private static final RuntimePermission PERMISSION = new RuntimePermission("io.undertow.servlet.CREATE_INITIAL_HANDLER");
    private final HttpHandler next;
    private final ThreadSetupHandler.Action<Object, ServletRequestContext> firstRequestHandler;
    private final ServletContextImpl servletContext;
    private final ApplicationListeners listeners;
    private final ServletPathMatches paths;
    private final ExceptionHandler exceptionHandler;
    private final HttpHandler dispatchHandler = new HttpHandler(){

        @Override
        public void handleRequest(final HttpServerExchange exchange2) throws Exception {
            final ServletRequestContext servletRequestContext = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            if (System.getSecurityManager() == null) {
                ServletInitialHandler.this.dispatchRequest(exchange2, servletRequestContext, servletRequestContext.getOriginalServletPathMatch().getServletChain(), DispatcherType.REQUEST);
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        ServletInitialHandler.this.dispatchRequest(exchange2, servletRequestContext, servletRequestContext.getOriginalServletPathMatch().getServletChain(), DispatcherType.REQUEST);
                        return null;
                    }
                });
            }
        }
    };

    public ServletInitialHandler(ServletPathMatches paths, HttpHandler next, Deployment deployment, ServletContextImpl servletContext) {
        ExceptionHandler handler;
        this.next = next;
        this.servletContext = servletContext;
        this.paths = paths;
        this.listeners = servletContext.getDeployment().getApplicationListeners();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        this.exceptionHandler = (handler = servletContext.getDeployment().getDeploymentInfo().getExceptionHandler()) != null ? handler : LoggingExceptionHandler.DEFAULT;
        this.firstRequestHandler = deployment.createThreadSetupAction(new ThreadSetupHandler.Action<Object, ServletRequestContext>(){

            @Override
            public Object call(HttpServerExchange exchange2, ServletRequestContext context) throws Exception {
                ServletInitialHandler.this.handleFirstRequest(exchange2, context);
                return null;
            }
        });
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        String path = exchange2.getRelativePath();
        if (this.isForbiddenPath(path)) {
            exchange2.setStatusCode(404);
            return;
        }
        ServletPathMatch info = this.paths.getServletHandlerByPath(path);
        if (info.getType() == ServletPathMatch.Type.REWRITE) {
            exchange2.setRelativePath(info.getRewriteLocation());
            exchange2.setRequestPath(exchange2.getResolvedPath() + info.getRewriteLocation());
        }
        HttpServletResponseImpl response = new HttpServletResponseImpl(exchange2, this.servletContext);
        HttpServletRequestImpl request = new HttpServletRequestImpl(exchange2, this.servletContext);
        ServletRequestContext servletRequestContext = new ServletRequestContext(this.servletContext.getDeployment(), request, response, info);
        if (info.getServletChain().getManagedServlet().getMaxRequestSize() > 0L && this.isMultiPartExchange(exchange2)) {
            exchange2.setMaxEntitySize(info.getServletChain().getManagedServlet().getMaxRequestSize());
        }
        exchange2.putAttachment(ServletRequestContext.ATTACHMENT_KEY, servletRequestContext);
        exchange2.startBlocking(new ServletBlockingHttpExchange(exchange2));
        servletRequestContext.setServletPathMatch(info);
        Executor executor = info.getServletChain().getExecutor();
        if (executor == null) {
            executor = this.servletContext.getDeployment().getExecutor();
        }
        if (exchange2.isInIoThread() || executor != null) {
            exchange2.dispatch(executor, this.dispatchHandler);
        } else {
            this.dispatchRequest(exchange2, servletRequestContext, info.getServletChain(), DispatcherType.REQUEST);
        }
    }

    private boolean isForbiddenPath(String path) {
        return path.equalsIgnoreCase("/meta-inf/") || path.regionMatches(true, 0, "/web-inf/", 0, "/web-inf/".length());
    }

    @Override
    public void dispatchToPath(HttpServerExchange exchange2, ServletPathMatch pathInfo, DispatcherType dispatcherType) throws Exception {
        ServletRequestContext servletRequestContext = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        servletRequestContext.setServletPathMatch(pathInfo);
        this.dispatchRequest(exchange2, servletRequestContext, pathInfo.getServletChain(), dispatcherType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchToServlet(HttpServerExchange exchange2, ServletChain servletchain, DispatcherType dispatcherType) throws Exception {
        ServletRequestContext servletRequestContext = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        DispatcherType oldDispatch = servletRequestContext.getDispatcherType();
        ServletChain oldChain = servletRequestContext.getCurrentServlet();
        try {
            this.dispatchRequest(exchange2, servletRequestContext, servletchain, dispatcherType);
        }
        finally {
            servletRequestContext.setDispatcherType(oldDispatch);
            servletRequestContext.setCurrentServlet(oldChain);
        }
    }

    @Override
    public void dispatchMockRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        DefaultByteBufferPool bufferPool = new DefaultByteBufferPool(false, 1024, 0, 0);
        MockServerConnection connection = new MockServerConnection(bufferPool);
        HttpServerExchange exchange2 = new HttpServerExchange(connection);
        exchange2.setRequestScheme(request.getScheme());
        exchange2.setRequestMethod(new HttpString(request.getMethod()));
        exchange2.setProtocol(Protocols.HTTP_1_0);
        exchange2.setResolvedPath(request.getContextPath());
        String relative = request.getPathInfo() == null ? request.getServletPath() : request.getServletPath() + request.getPathInfo();
        exchange2.setRelativePath(relative);
        ServletPathMatch info = this.paths.getServletHandlerByPath(request.getServletPath());
        HttpServletResponseImpl oResponse = new HttpServletResponseImpl(exchange2, this.servletContext);
        HttpServletRequestImpl oRequest = new HttpServletRequestImpl(exchange2, this.servletContext);
        ServletRequestContext servletRequestContext = new ServletRequestContext(this.servletContext.getDeployment(), oRequest, oResponse, info);
        servletRequestContext.setServletRequest(request);
        servletRequestContext.setServletResponse(response);
        if (info.getServletChain().getManagedServlet().getMaxRequestSize() > 0L && this.isMultiPartExchange(exchange2)) {
            exchange2.setMaxEntitySize(info.getServletChain().getManagedServlet().getMaxRequestSize());
        }
        exchange2.putAttachment(ServletRequestContext.ATTACHMENT_KEY, servletRequestContext);
        exchange2.startBlocking(new ServletBlockingHttpExchange(exchange2));
        servletRequestContext.setServletPathMatch(info);
        try {
            this.dispatchRequest(exchange2, servletRequestContext, info.getServletChain(), DispatcherType.REQUEST);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException(e);
        }
    }

    private boolean isMultiPartExchange(HttpServerExchange exhange) {
        HeaderValues contentTypeHeaders = exhange.getRequestHeaders().get("Content-Type");
        if (contentTypeHeaders != null && contentTypeHeaders.size() > 0) {
            return contentTypeHeaders.getFirst().startsWith("multipart");
        }
        return false;
    }

    private void dispatchRequest(HttpServerExchange exchange2, ServletRequestContext servletRequestContext, ServletChain servletChain, DispatcherType dispatcherType) throws Exception {
        servletRequestContext.setDispatcherType(dispatcherType);
        servletRequestContext.setCurrentServlet(servletChain);
        if (dispatcherType == DispatcherType.REQUEST || dispatcherType == DispatcherType.ASYNC) {
            this.firstRequestHandler.call(exchange2, servletRequestContext);
        } else {
            this.next.handleRequest(exchange2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFirstRequest(HttpServerExchange exchange2, ServletRequestContext servletRequestContext) throws Exception {
        AsyncContextImpl ctx;
        ServletRequest request = servletRequestContext.getServletRequest();
        ServletResponse response = servletRequestContext.getServletResponse();
        Map<String, String> attrs = exchange2.getAttachment(HttpServerExchange.REQUEST_ATTRIBUTES);
        if (attrs != null) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                request.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        servletRequestContext.setRunningInsideHandler(true);
        try {
            this.listeners.requestInitialized(request);
            this.next.handleRequest(exchange2);
            AsyncContextImpl asyncContextInternal = servletRequestContext.getOriginalRequest().getAsyncContextInternal();
            if (asyncContextInternal != null && asyncContextInternal.isCompletedBeforeInitialRequestDone()) {
                asyncContextInternal.handleCompletedBeforeInitialRequestDone();
            }
            if (servletRequestContext.getErrorCode() > 0) {
                servletRequestContext.getOriginalResponse().doErrorDispatch(servletRequestContext.getErrorCode(), servletRequestContext.getErrorMessage());
            }
        }
        catch (Throwable t) {
            boolean handled;
            servletRequestContext.setRunningInsideHandler(false);
            AsyncContextImpl asyncContextInternal = servletRequestContext.getOriginalRequest().getAsyncContextInternal();
            if (asyncContextInternal != null && asyncContextInternal.isCompletedBeforeInitialRequestDone()) {
                asyncContextInternal.handleCompletedBeforeInitialRequestDone();
            }
            if (asyncContextInternal != null) {
                asyncContextInternal.initialRequestFailed();
            }
            if (handled = this.exceptionHandler.handleThrowable(exchange2, request, response, t)) {
                exchange2.endExchange();
            } else if (request.isAsyncStarted() || request.getDispatcherType() == DispatcherType.ASYNC) {
                exchange2.unDispatch();
                servletRequestContext.getOriginalRequest().getAsyncContextInternal().handleError(t);
            } else if (!exchange2.isResponseStarted()) {
                response.reset();
                exchange2.setStatusCode(500);
                exchange2.getResponseHeaders().clear();
                String location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(t);
                if (location == null) {
                    location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(500);
                }
                if (location != null) {
                    RequestDispatcherImpl dispatcher = new RequestDispatcherImpl(location, this.servletContext);
                    try {
                        dispatcher.error(servletRequestContext, request, response, servletRequestContext.getOriginalServletPathMatch().getServletChain().getManagedServlet().getServletInfo().getName(), t);
                    }
                    catch (Exception e) {
                        UndertowLogger.REQUEST_LOGGER.exceptionGeneratingErrorPage(e, location);
                    }
                } else if (servletRequestContext.displayStackTraces()) {
                    ServletDebugPageHandler.handleRequest(exchange2, servletRequestContext, t);
                } else {
                    servletRequestContext.getOriginalResponse().doErrorDispatch(500, "Internal Server Error");
                }
            }
        }
        finally {
            servletRequestContext.setRunningInsideHandler(false);
            this.listeners.requestDestroyed(request);
        }
        if (!exchange2.isDispatched() && !(exchange2.getConnection() instanceof MockServerConnection)) {
            servletRequestContext.getOriginalResponse().responseDone();
        }
        if (!exchange2.isDispatched() && (ctx = servletRequestContext.getOriginalRequest().getAsyncContextInternal()) != null) {
            ctx.complete();
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    private static class MockServerConnection
    extends ServerConnection {
        private final ByteBufferPool bufferPool;
        private SSLSessionInfo sslSessionInfo;
        private XnioBufferPoolAdaptor poolAdaptor;

        private MockServerConnection(ByteBufferPool bufferPool) {
            this.bufferPool = bufferPool;
        }

        @Override
        public Pool<ByteBuffer> getBufferPool() {
            if (this.poolAdaptor == null) {
                this.poolAdaptor = new XnioBufferPoolAdaptor(this.getByteBufferPool());
            }
            return this.poolAdaptor;
        }

        @Override
        public ByteBufferPool getByteBufferPool() {
            return this.bufferPool;
        }

        @Override
        public XnioWorker getWorker() {
            return null;
        }

        @Override
        public XnioIoThread getIoThread() {
            return null;
        }

        @Override
        public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange2) {
            throw UndertowMessages.MESSAGES.outOfBandResponseNotSupported();
        }

        @Override
        public boolean isContinueResponseSupported() {
            return false;
        }

        @Override
        public void terminateRequestChannel(HttpServerExchange exchange2) {
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public boolean supportsOption(Option<?> option) {
            return false;
        }

        @Override
        public <T> T getOption(Option<T> option) throws IOException {
            return null;
        }

        @Override
        public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public SocketAddress getPeerAddress() {
            return null;
        }

        @Override
        public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
            return null;
        }

        @Override
        public ChannelListener.Setter<? extends ConnectedChannel> getCloseSetter() {
            return null;
        }

        @Override
        public SocketAddress getLocalAddress() {
            return null;
        }

        @Override
        public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
            return null;
        }

        @Override
        public OptionMap getUndertowOptions() {
            return OptionMap.EMPTY;
        }

        @Override
        public int getBufferSize() {
            return 1024;
        }

        @Override
        public SSLSessionInfo getSslSessionInfo() {
            return this.sslSessionInfo;
        }

        @Override
        public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
            this.sslSessionInfo = sessionInfo;
        }

        @Override
        public void addCloseListener(ServerConnection.CloseListener listener) {
        }

        @Override
        public StreamConnection upgradeChannel() {
            return null;
        }

        @Override
        public ConduitStreamSinkChannel getSinkChannel() {
            return null;
        }

        @Override
        public ConduitStreamSourceChannel getSourceChannel() {
            return new ConduitStreamSourceChannel(null, null);
        }

        @Override
        protected StreamSinkConduit getSinkConduit(HttpServerExchange exchange2, StreamSinkConduit conduit) {
            return conduit;
        }

        @Override
        protected boolean isUpgradeSupported() {
            return false;
        }

        @Override
        protected boolean isConnectSupported() {
            return false;
        }

        @Override
        protected void exchangeComplete(HttpServerExchange exchange2) {
        }

        @Override
        protected void setUpgradeListener(HttpUpgradeListener upgradeListener) {
        }

        @Override
        protected void setConnectListener(HttpUpgradeListener connectListener) {
        }

        @Override
        protected void maxEntitySizeUpdated(HttpServerExchange exchange2) {
        }

        @Override
        public String getTransportProtocol() {
            return "mock";
        }

        @Override
        public boolean isRequestTrailerFieldsSupported() {
            return false;
        }
    }
}

