/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowMessages;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.util.SubstringMap;
import java.util.HashMap;
import java.util.Map;

class ServletPathMatchesData {
    private final Map<String, ServletPathMatch> exactPathMatches;
    private final SubstringMap<PathMatch> prefixMatches;
    private final Map<String, ServletChain> nameMatches;

    ServletPathMatchesData(Map<String, ServletChain> exactPathMatches, SubstringMap<PathMatch> prefixMatches, Map<String, ServletChain> nameMatches) {
        this.prefixMatches = prefixMatches;
        this.nameMatches = nameMatches;
        HashMap<String, ServletPathMatch> newExactPathMatches = new HashMap<String, ServletPathMatch>();
        for (Map.Entry<String, ServletChain> entry : exactPathMatches.entrySet()) {
            newExactPathMatches.put(entry.getKey(), new ServletPathMatch(entry.getValue(), entry.getKey(), entry.getValue().isDefaultServletMapping()));
        }
        this.exactPathMatches = newExactPathMatches;
    }

    public ServletChain getServletHandlerByName(String name) {
        return this.nameMatches.get(name);
    }

    public ServletPathMatch getServletHandlerByExactPath(String path) {
        return this.exactPathMatches.get(path);
    }

    public ServletPathMatch getServletHandlerByPath(String path) {
        ServletPathMatch exact = this.exactPathMatches.get(path);
        if (exact != null) {
            return exact;
        }
        SubstringMap.SubstringMatch<PathMatch> match = this.prefixMatches.get(path, path.length());
        if (match != null) {
            return this.handleMatch(path, match.getValue(), path.lastIndexOf(46));
        }
        int extensionPos = -1;
        for (int i2 = path.length() - 1; i2 >= 0; --i2) {
            char c = path.charAt(i2);
            if (c == '/') {
                match = this.prefixMatches.get(path, i2);
                if (match == null) continue;
                return this.handleMatch(path, match.getValue(), extensionPos);
            }
            if (c != '.' || extensionPos != -1) continue;
            extensionPos = i2;
        }
        throw UndertowMessages.MESSAGES.servletPathMatchFailed();
    }

    private ServletPathMatch handleMatch(String path, PathMatch match, int extensionPos) {
        if (extensionPos == -1 || match.extensionMatches.isEmpty()) {
            return new ServletPathMatch(match.defaultHandler, path, match.requireWelcomeFileMatch);
        }
        String ext = path.substring(extensionPos + 1);
        ServletChain handler = (ServletChain)match.extensionMatches.get(ext);
        if (handler != null) {
            return new ServletPathMatch(handler, path, handler.getManagedServlet().getServletInfo().isRequireWelcomeFileMapping());
        }
        return new ServletPathMatch(match.defaultHandler, path, match.requireWelcomeFileMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class PathMatch {
        private final Map<String, ServletChain> extensionMatches = new HashMap<String, ServletChain>();
        private volatile ServletChain defaultHandler;
        private volatile boolean requireWelcomeFileMatch;

        PathMatch(ServletChain defaultHandler) {
            this.defaultHandler = defaultHandler;
        }
    }

    public static final class Builder {
        private final Map<String, ServletChain> exactPathMatches = new HashMap<String, ServletChain>();
        private final SubstringMap<PathMatch> prefixMatches = new SubstringMap();
        private final Map<String, ServletChain> nameMatches = new HashMap<String, ServletChain>();

        public void addExactMatch(String exactMatch, ServletChain match) {
            this.exactPathMatches.put(exactMatch, match);
        }

        public void addPrefixMatch(String prefix, ServletChain match, boolean requireWelcomeFileMatch) {
            PathMatch m3;
            SubstringMap.SubstringMatch<PathMatch> mt = this.prefixMatches.get(prefix);
            if (mt == null) {
                m3 = new PathMatch(match);
                this.prefixMatches.put(prefix, m3);
            } else {
                m3 = mt.getValue();
            }
            m3.defaultHandler = match;
            m3.requireWelcomeFileMatch = requireWelcomeFileMatch;
        }

        public void addExtensionMatch(String prefix, String extension, ServletChain match) {
            PathMatch m3;
            SubstringMap.SubstringMatch<PathMatch> mt = this.prefixMatches.get(prefix);
            if (mt == null) {
                m3 = new PathMatch(null);
                this.prefixMatches.put(prefix, m3);
            } else {
                m3 = mt.getValue();
            }
            m3.extensionMatches.put(extension, match);
        }

        public void addNameMatch(String name, ServletChain match) {
            this.nameMatches.put(name, match);
        }

        public ServletPathMatchesData build() {
            return new ServletPathMatchesData(this.exactPathMatches, this.prefixMatches, this.nameMatches);
        }
    }
}

