/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;

public class ServletAuthenticationCallHandler
implements HttpHandler {
    private final HttpHandler next;

    public ServletAuthenticationCallHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        if (exchange2.isInIoThread()) {
            exchange2.dispatch(this);
            return;
        }
        SecurityContext context = exchange2.getSecurityContext();
        if (context.authenticate()) {
            if (!exchange2.isComplete()) {
                this.next.handleRequest(exchange2);
            }
        } else if (exchange2.getStatusCode() >= 400 && !exchange2.isComplete()) {
            ServletRequestContext src = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            src.getOriginalResponse().sendError(exchange2.getStatusCode());
        } else {
            exchange2.endExchange();
        }
    }
}

