/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.impl.SingleSignOnAuthenticationMechanism;
import io.undertow.security.impl.SingleSignOnManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.security.AccessController;

public class ServletSingleSignOnAuthenticationMechanism
extends SingleSignOnAuthenticationMechanism {
    public ServletSingleSignOnAuthenticationMechanism(SingleSignOnManager storage) {
        super(storage);
    }

    @Override
    protected Session getSession(HttpServerExchange exchange2) {
        ServletRequestContext servletRequestContext = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpSessionImpl session = servletRequestContext.getCurrentServletContext().getSession(exchange2, true);
        if (System.getSecurityManager() == null) {
            return session.getSession();
        }
        return AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(session));
    }
}

