/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.WorkerUtils;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class DateUtils {
    private static final Locale LOCALE_US = Locale.US;
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final AtomicReference<String> cachedDateString = new AtomicReference();
    private static final ThreadLocal<SimpleDateFormat> RFC1123_PATTERN_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(DateUtils.RFC1123_PATTERN, LOCALE_US);
            return df;
        }
    };
    private static final Runnable INVALIDATE_TASK = new Runnable(){

        @Override
        public void run() {
            cachedDateString.set(null);
        }
    };
    private static final String RFC1036_PATTERN = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String ASCITIME_PATTERN = "EEE MMM d HH:mm:ss yyyyy";
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final String COMMON_LOG_PATTERN = "[dd/MMM/yyyy:HH:mm:ss Z]";
    private static final ThreadLocal<SimpleDateFormat> COMMON_LOG_PATTERN_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(DateUtils.COMMON_LOG_PATTERN, LOCALE_US);
            return df;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> OLD_COOKIE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat(DateUtils.OLD_COOKIE_PATTERN, LOCALE_US);
            df.setTimeZone(GMT_ZONE);
            return df;
        }
    };

    public static String toDateString(Date date) {
        SimpleDateFormat df = RFC1123_PATTERN_FORMAT.get();
        df.setTimeZone(GMT_ZONE);
        return df.format(date);
    }

    public static String toOldCookieDateString(Date date) {
        return OLD_COOKIE_FORMAT.get().format(date);
    }

    public static String toCommonLogFormat(Date date) {
        return COMMON_LOG_PATTERN_FORMAT.get().format(date);
    }

    public static Date parseDate(String date) {
        int semicolonIndex = date.indexOf(59);
        String trimmedDate = semicolonIndex >= 0 ? date.substring(0, semicolonIndex) : date;
        ParsePosition pp = new ParsePosition(0);
        SimpleDateFormat dateFormat = RFC1123_PATTERN_FORMAT.get();
        dateFormat.setTimeZone(GMT_ZONE);
        Date val = dateFormat.parse(trimmedDate, pp);
        if (val != null && pp.getIndex() == trimmedDate.length()) {
            return val;
        }
        pp = new ParsePosition(0);
        dateFormat = new SimpleDateFormat(RFC1036_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        val = dateFormat.parse(trimmedDate, pp);
        if (val != null && pp.getIndex() == trimmedDate.length()) {
            return val;
        }
        pp = new ParsePosition(0);
        dateFormat = new SimpleDateFormat(ASCITIME_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        val = dateFormat.parse(trimmedDate, pp);
        if (val != null && pp.getIndex() == trimmedDate.length()) {
            return val;
        }
        pp = new ParsePosition(0);
        dateFormat = new SimpleDateFormat(OLD_COOKIE_PATTERN, LOCALE_US);
        dateFormat.setTimeZone(GMT_ZONE);
        val = dateFormat.parse(trimmedDate, pp);
        if (val != null && pp.getIndex() == trimmedDate.length()) {
            return val;
        }
        return null;
    }

    public static boolean handleIfModifiedSince(HttpServerExchange exchange2, Date lastModified) {
        return DateUtils.handleIfModifiedSince(exchange2.getRequestHeaders().getFirst(Headers.IF_MODIFIED_SINCE), lastModified);
    }

    public static boolean handleIfModifiedSince(String modifiedSince, Date lastModified) {
        if (lastModified == null) {
            return true;
        }
        if (modifiedSince == null) {
            return true;
        }
        Date modDate = DateUtils.parseDate(modifiedSince);
        if (modDate == null) {
            return true;
        }
        return lastModified.getTime() > modDate.getTime() + 999L;
    }

    public static boolean handleIfUnmodifiedSince(HttpServerExchange exchange2, Date lastModified) {
        return DateUtils.handleIfUnmodifiedSince(exchange2.getRequestHeaders().getFirst(Headers.IF_UNMODIFIED_SINCE), lastModified);
    }

    public static boolean handleIfUnmodifiedSince(String modifiedSince, Date lastModified) {
        if (lastModified == null) {
            return true;
        }
        if (modifiedSince == null) {
            return true;
        }
        Date modDate = DateUtils.parseDate(modifiedSince);
        if (modDate == null) {
            return true;
        }
        return lastModified.getTime() < modDate.getTime() + 999L;
    }

    public static void addDateHeaderIfRequired(HttpServerExchange exchange2) {
        HeaderMap responseHeaders = exchange2.getResponseHeaders();
        if (exchange2.getConnection().getUndertowOptions().get(UndertowOptions.ALWAYS_SET_DATE, true) && !responseHeaders.contains(Headers.DATE)) {
            String dateString = DateUtils.getCurrentDateTime(exchange2);
            responseHeaders.put(Headers.DATE, dateString);
        }
    }

    public static String getCurrentDateTime(HttpServerExchange exchange2) {
        String dateString = cachedDateString.get();
        if (dateString == null) {
            long realTime = System.currentTimeMillis();
            long mod = realTime % 1000L;
            long toGo = 1000L - mod;
            dateString = DateUtils.toDateString(new Date(realTime));
            if (cachedDateString.compareAndSet(null, dateString)) {
                WorkerUtils.executeAfter(exchange2.getIoThread(), INVALIDATE_TASK, toGo, TimeUnit.MILLISECONDS);
            }
        }
        return dateString;
    }

    private DateUtils() {
    }
}

