/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.DefaultContainerConfigurator;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpoint;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.xnio.IoUtils;

public final class EndpointSessionHandler
implements WebSocketConnectionCallback {
    private final ServerWebSocketContainer container;

    public EndpointSessionHandler(ServerWebSocketContainer container) {
        this.container = container;
    }

    ServerWebSocketContainer getContainer() {
        return this.container;
    }

    @Override
    public void onConnect(WebSocketHttpExchange exchange2, WebSocketChannel channel) {
        ConfiguredServerEndpoint config = HandshakeUtil.getConfig(channel);
        try {
            ImmediateInstanceHandle<Endpoint> endpointInstance;
            if (this.container.isClosed()) {
                channel.sendClose();
                channel.resumeReceives();
                return;
            }
            InstanceFactory<?> endpointFactory = config.getEndpointFactory();
            ServerEndpointConfig.Configurator configurator = config.getEndpointConfiguration().getConfigurator();
            DefaultContainerConfigurator.setCurrentInstanceFactory(endpointFactory);
            final Object instanceFromConfigurator = configurator.getEndpointInstance(config.getEndpointConfiguration().getEndpointClass());
            final InstanceHandle<?> factoryInstance = DefaultContainerConfigurator.clearCurrentInstanceFactory();
            final InstanceHandle<Object> instance = factoryInstance == null ? new ImmediateInstanceHandle(instanceFromConfigurator) : (factoryInstance.getInstance() == instanceFromConfigurator ? factoryInstance : new InstanceHandle<Object>(){

                @Override
                public Object getInstance() {
                    return instanceFromConfigurator;
                }

                @Override
                public void release() {
                    factoryInstance.release();
                }
            });
            ServletRequestContext src = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            Principal principal = exchange2.getAttachment(HandshakeUtil.PRINCIPAL);
            if (principal == null) {
                principal = src.getServletRequest() instanceof HttpServletRequest ? ((HttpServletRequest)src.getServletRequest()).getUserPrincipal() : src.getOriginalRequest().getUserPrincipal();
            }
            if (config.getAnnotatedEndpointFactory() != null) {
                final AnnotatedEndpoint annotated = config.getAnnotatedEndpointFactory().createInstance(instance);
                endpointInstance = new InstanceHandle<Endpoint>(){

                    @Override
                    public Endpoint getInstance() {
                        return annotated;
                    }

                    @Override
                    public void release() {
                        instance.release();
                    }
                };
            } else {
                endpointInstance = instance;
            }
            UndertowSession session = new UndertowSession(channel, URI.create(exchange2.getRequestURI()), exchange2.getAttachment(HandshakeUtil.PATH_PARAMS), exchange2.getRequestParameters(), this, principal, endpointInstance, config.getEndpointConfiguration(), exchange2.getQueryString(), config.getEncodingFactory().createEncoding(config.getEndpointConfiguration()), config, channel.getSubProtocol(), Collections.emptyList(), null);
            config.addOpenSession(session);
            session.setMaxBinaryMessageBufferSize(this.getContainer().getDefaultMaxBinaryMessageBufferSize());
            session.setMaxTextMessageBufferSize(this.getContainer().getDefaultMaxTextMessageBufferSize());
            session.setMaxIdleTimeout(this.getContainer().getDefaultMaxSessionIdleTimeout());
            session.getAsyncRemote().setSendTimeout(this.getContainer().getDefaultAsyncSendTimeout());
            try {
                ((Endpoint)endpointInstance.getInstance()).onOpen(session, config.getEndpointConfiguration());
            }
            catch (Exception e) {
                ((Endpoint)endpointInstance.getInstance()).onError(session, e);
                IoUtils.safeClose((Closeable)session);
            }
            channel.resumeReceives();
        }
        catch (Exception e) {
            JsrWebSocketLogger.REQUEST_LOGGER.endpointCreationFailed(e);
            IoUtils.safeClose((Closeable)channel);
        }
    }
}

