/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpoint;
import io.undertow.websockets.jsr.annotated.BoundMethod;
import io.undertow.websockets.jsr.annotated.BoundParameter;
import io.undertow.websockets.jsr.annotated.EmptyEndpointConfig;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;

public class AnnotatedEndpointFactory {
    private final Class<?> endpointClass;
    private final BoundMethod OnOpen;
    private final BoundMethod OnClose;
    private final BoundMethod OnError;
    private final BoundMethod textMessage;
    private final BoundMethod binaryMessage;
    private final BoundMethod pongMessage;

    private AnnotatedEndpointFactory(Class<?> endpointClass, BoundMethod OnOpen2, BoundMethod OnClose2, BoundMethod OnError2, BoundMethod textMessage, BoundMethod binaryMessage, BoundMethod pongMessage) {
        this.endpointClass = endpointClass;
        this.OnOpen = OnOpen2;
        this.OnClose = OnClose2;
        this.OnError = OnError2;
        this.textMessage = textMessage;
        this.binaryMessage = binaryMessage;
        this.pongMessage = pongMessage;
    }

    public static AnnotatedEndpointFactory create(Class<?> endpointClass, EncodingFactory encodingFactory, Set<String> paths) throws DeploymentException {
        HashSet<Class<OnError>> found = new HashSet<Class<OnError>>();
        BoundMethod onOpen = null;
        BoundMethod onClose = null;
        BoundMethod onError2 = null;
        BoundMethod textMessage = null;
        BoundMethod binaryMessage = null;
        BoundMethod pongMessage = null;
        Class<?> c = endpointClass;
        do {
            for (Method method : c.getDeclaredMethods()) {
                if (method.isAnnotationPresent(OnOpen.class)) {
                    if (found.contains(OnOpen.class)) {
                        if (onOpen.overrides(method)) continue;
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnOpen.class);
                    }
                    found.add(OnOpen.class);
                    onOpen = new BoundMethod(method, null, false, 0L, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, EndpointConfig.class, true), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                }
                if (method.isAnnotationPresent(OnClose.class)) {
                    if (found.contains(OnClose.class)) {
                        if (onClose.overrides(method)) continue;
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnClose.class);
                    }
                    found.add(OnClose.class);
                    onClose = new BoundMethod(method, null, false, 0L, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, CloseReason.class, true), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                }
                if (method.isAnnotationPresent(OnError.class)) {
                    if (found.contains(OnError.class)) {
                        if (onError2.overrides(method)) continue;
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnError.class);
                    }
                    found.add(OnError.class);
                    onError2 = new BoundMethod(method, null, false, 0L, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Throwable.class, false), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                }
                if (!method.isAnnotationPresent(OnMessage.class) || method.isBridge() || binaryMessage != null && binaryMessage.overrides(method) || textMessage != null && textMessage.overrides(method) || pongMessage != null && pongMessage.overrides(method)) continue;
                long maxMessageSize = method.getAnnotation(OnMessage.class).maxMessageSize();
                boolean messageHandled = false;
                Class<?>[] parameterTypes = method.getParameterTypes();
                int booleanLocation = -1;
                for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                    if (AnnotatedEndpointFactory.hasAnnotation(PathParam.class, method.getParameterAnnotations()[i2])) continue;
                    Class<?> param = parameterTypes[i2];
                    if (param == Boolean.TYPE || param == Boolean.class) {
                        booleanLocation = i2;
                        continue;
                    }
                    if (encodingFactory.canDecodeText(param)) {
                        if (textMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        textMessage = new BoundMethod(method, param, true, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(i2, param), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (encodingFactory.canDecodeBinary(param)) {
                        if (binaryMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryMessage = new BoundMethod(method, param, true, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(i2, param), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(byte[].class)) {
                        if (binaryMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryMessage = new BoundMethod(method, byte[].class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i2, byte[].class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(ByteBuffer.class)) {
                        if (binaryMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryMessage = new BoundMethod(method, ByteBuffer.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i2, ByteBuffer.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(InputStream.class)) {
                        if (binaryMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryMessage = new BoundMethod(method, InputStream.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(i2, InputStream.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(String.class) && AnnotatedEndpointFactory.getPathParam(method, i2) == null) {
                        if (textMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        textMessage = new BoundMethod(method, String.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i2, String.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(Reader.class) && AnnotatedEndpointFactory.getPathParam(method, i2) == null) {
                        if (textMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        textMessage = new BoundMethod(method, Reader.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(i2, Reader.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (!param.equals(PongMessage.class)) continue;
                    if (pongMessage != null) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                    }
                    pongMessage = new BoundMethod(method, PongMessage.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(i2, PongMessage.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                    messageHandled = true;
                    break;
                }
                if (!messageHandled && booleanLocation != -1) {
                    if (textMessage != null) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                    }
                    Class<?> boolClass = parameterTypes[booleanLocation];
                    textMessage = new BoundMethod(method, boolClass, true, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(booleanLocation, boolClass), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                    messageHandled = true;
                }
                if (messageHandled) continue;
                throw JsrWebSocketMessages.MESSAGES.couldNotFindMessageParameter(method);
            }
        } while ((c = c.getSuperclass()) != Object.class && c != null);
        return new AnnotatedEndpointFactory(endpointClass, onOpen, onClose, onError2, textMessage, binaryMessage, pongMessage);
    }

    private static BoundPathParameters createBoundPathParameters(Method method, Set<String> paths, Class<?> endpointClass) throws DeploymentException {
        return new BoundPathParameters(AnnotatedEndpointFactory.pathParams(method), method, endpointClass, paths);
    }

    private static String[] pathParams(Method method) {
        String[] params = new String[method.getParameterCount()];
        for (int i2 = 0; i2 < method.getParameterCount(); ++i2) {
            PathParam param = AnnotatedEndpointFactory.getPathParam(method, i2);
            if (param == null) continue;
            params[i2] = param.value();
        }
        return params;
    }

    private static PathParam getPathParam(Method method, int parameter) {
        for (Annotation annotation : method.getParameterAnnotations()[parameter]) {
            if (!annotation.annotationType().equals(PathParam.class)) continue;
            return (PathParam)annotation;
        }
        return null;
    }

    private static boolean hasAnnotation(Class<? extends Annotation> annotationType, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public AnnotatedEndpoint createInstance(InstanceHandle<?> endpointInstance) {
        if (!this.endpointClass.isInstance(endpointInstance.getInstance())) {
            throw JsrWebSocketMessages.MESSAGES.endpointNotOfCorrectType(endpointInstance, this.endpointClass);
        }
        return new AnnotatedEndpoint(endpointInstance, this.OnOpen, this.OnClose, this.OnError, this.textMessage, this.binaryMessage, this.pongMessage);
    }

    private static class BoundPathParameters
    implements BoundParameter {
        private final Class<?> endpointClass;
        private final Set<String> paths;
        private final String[] positions;
        private final Encoding[] encoders;
        private final Class[] types;

        BoundPathParameters(String[] positions, Method method, Class<?> endpointClass, Set<String> paths) throws DeploymentException {
            this.positions = positions;
            this.endpointClass = endpointClass;
            this.paths = paths;
            this.encoders = new Encoding[positions.length];
            this.types = new Class[positions.length];
            for (int i2 = 0; i2 < positions.length; ++i2) {
                Class<?> type = method.getParameterTypes()[i2];
                Annotation[] annotations = method.getParameterAnnotations()[i2];
                for (int j = 0; j < annotations.length; ++j) {
                    PathParam param;
                    if (!(annotations[j] instanceof PathParam) || paths.contains((param = (PathParam)annotations[j]).value())) continue;
                    JsrWebSocketLogger.ROOT_LOGGER.pathTemplateNotFound(endpointClass, param, method, paths);
                }
                if (positions[i2] == null || type == null || type == String.class) continue;
                if (EncodingFactory.DEFAULT.canEncodeText(type)) {
                    this.encoders[i2] = EncodingFactory.DEFAULT.createEncoding(EmptyEndpointConfig.INSTANCE);
                    this.types[i2] = type;
                    continue;
                }
                throw JsrWebSocketMessages.MESSAGES.couldNotFindDecoderForType(type, method);
            }
        }

        @Override
        public Set<Integer> positions() {
            HashSet<Integer> ret = new HashSet<Integer>();
            for (int i2 = 0; i2 < this.positions.length; ++i2) {
                if (this.positions[i2] == null) continue;
                ret.add(i2);
            }
            return ret;
        }

        @Override
        public void populate(Object[] params, Map<Class<?>, Object> value) throws DecodeException {
            Map data = (Map)value.get(Map.class);
            for (int i2 = 0; i2 < this.positions.length; ++i2) {
                String name = this.positions[i2];
                if (name == null) continue;
                Encoding encoding = this.encoders[i2];
                params[i2] = encoding == null ? data.get(name) : encoding.decodeText(this.types[i2], (String)data.get(name));
            }
        }

        @Override
        public Class<?> getType() {
            return Map.class;
        }
    }

    private static class BoundSingleParameter
    implements BoundParameter {
        private final int position;
        private final Class<?> type;

        BoundSingleParameter(int position, Class<?> type) {
            this.position = position;
            this.type = type;
        }

        BoundSingleParameter(Method method, Class<?> type, boolean optional) {
            this.type = type;
            int pos = -1;
            for (int i2 = 0; i2 < method.getParameterCount(); ++i2) {
                boolean pathParam = false;
                for (Annotation annotation : method.getParameterAnnotations()[i2]) {
                    if (!annotation.annotationType().equals(PathParam.class)) continue;
                    pathParam = true;
                    break;
                }
                if (pathParam || !method.getParameterTypes()[i2].equals(type)) continue;
                if (pos != -1) {
                    throw JsrWebSocketMessages.MESSAGES.moreThanOneParameterOfType(type, method);
                }
                pos = i2;
            }
            if (pos != -1) {
                this.position = pos;
            } else if (optional) {
                this.position = -1;
            } else {
                throw JsrWebSocketMessages.MESSAGES.parameterNotFound(type, method);
            }
        }

        @Override
        public Set<Integer> positions() {
            if (this.position == -1) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.position);
        }

        @Override
        public void populate(Object[] params, Map<Class<?>, Object> value) {
            if (this.position == -1) {
                return;
            }
            params[this.position] = value.get(this.type);
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }
}

