/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.aspectj.internal.lang.reflect.InterTypeDeclarationImpl;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.InterTypeConstructorDeclaration;

public class InterTypeConstructorDeclarationImpl
extends InterTypeDeclarationImpl
implements InterTypeConstructorDeclaration {
    private Method baseMethod;

    public InterTypeConstructorDeclarationImpl(AjType<?> decType, String target, int mods, Method baseMethod) {
        super(decType, target, mods);
        this.baseMethod = baseMethod;
    }

    @Override
    public AjType<?>[] getParameterTypes() {
        Class<?>[] baseTypes = this.baseMethod.getParameterTypes();
        AjType[] ret = new AjType[baseTypes.length - 1];
        for (int i2 = 1; i2 < baseTypes.length; ++i2) {
            ret[i2 - 1] = AjTypeSystem.getAjType(baseTypes[i2]);
        }
        return ret;
    }

    @Override
    public Type[] getGenericParameterTypes() {
        Type[] baseTypes = this.baseMethod.getGenericParameterTypes();
        Type[] ret = new AjType[baseTypes.length - 1];
        for (int i2 = 1; i2 < baseTypes.length; ++i2) {
            ret[i2 - 1] = baseTypes[i2] instanceof Class ? AjTypeSystem.getAjType((Class)baseTypes[i2]) : baseTypes[i2];
        }
        return ret;
    }

    @Override
    public AjType<?>[] getExceptionTypes() {
        Class<?>[] baseTypes = this.baseMethod.getExceptionTypes();
        AjType[] ret = new AjType[baseTypes.length];
        for (int i2 = 0; i2 < baseTypes.length; ++i2) {
            ret[i2] = AjTypeSystem.getAjType(baseTypes[i2]);
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(this.getModifiers()));
        sb.append(" ");
        sb.append(this.targetTypeName);
        sb.append(".new");
        sb.append("(");
        AjType<?>[] pTypes = this.getParameterTypes();
        for (int i2 = 0; i2 < pTypes.length - 1; ++i2) {
            sb.append(pTypes[i2].toString());
            sb.append(", ");
        }
        if (pTypes.length > 0) {
            sb.append(pTypes[pTypes.length - 1].toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

