/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow.util;

import org.bouncycastle.pqc.crypto.rainbow.util.GF2Field;

public class ComputeInField {
    private short[][] A;
    short[] x;

    public short[] solveEquation(short[][] sArray, short[] sArray2) {
        try {
            int n;
            if (sArray.length != sArray2.length) {
                throw new RuntimeException("The equation system is not solvable");
            }
            this.A = new short[sArray.length][sArray.length + 1];
            this.x = new short[sArray.length];
            for (n = 0; n < sArray.length; ++n) {
                for (int j = 0; j < sArray[0].length; ++j) {
                    this.A[n][j] = sArray[n][j];
                }
            }
            for (n = 0; n < sArray2.length; ++n) {
                this.A[n][sArray2.length] = GF2Field.addElem(sArray2[n], this.A[n][sArray2.length]);
            }
            this.computeZerosUnder(false);
            this.substitute();
            return this.x;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public short[][] inverse(short[][] sArray) {
        try {
            int n;
            int n2;
            this.A = new short[sArray.length][2 * sArray.length];
            if (sArray.length != sArray[0].length) {
                throw new RuntimeException("The matrix is not invertible. Please choose another one!");
            }
            for (n2 = 0; n2 < sArray.length; ++n2) {
                for (n = 0; n < sArray.length; ++n) {
                    this.A[n2][n] = sArray[n2][n];
                }
                for (n = sArray.length; n < 2 * sArray.length; ++n) {
                    this.A[n2][n] = 0;
                }
                this.A[n2][n2 + this.A.length] = 1;
            }
            this.computeZerosUnder(true);
            for (n2 = 0; n2 < this.A.length; ++n2) {
                short s2 = GF2Field.invElem(this.A[n2][n2]);
                for (n = n2; n < 2 * this.A.length; ++n) {
                    this.A[n2][n] = GF2Field.multElem(this.A[n2][n], s2);
                }
            }
            this.computeZerosAbove();
            short[][] sArray2 = new short[this.A.length][this.A.length];
            for (n2 = 0; n2 < this.A.length; ++n2) {
                for (n = this.A.length; n < 2 * this.A.length; ++n) {
                    sArray2[n2][n - this.A.length] = this.A[n2][n];
                }
            }
            return sArray2;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private void computeZerosUnder(boolean bl) throws RuntimeException {
        short s2 = 0;
        int n = bl ? 2 * this.A.length : this.A.length + 1;
        for (int j = 0; j < this.A.length - 1; ++j) {
            for (int k = j + 1; k < this.A.length; ++k) {
                short s3 = this.A[k][j];
                short s4 = GF2Field.invElem(this.A[j][j]);
                if (s4 == 0) {
                    throw new RuntimeException("Matrix not invertible! We have to choose another one!");
                }
                for (int i2 = j; i2 < n; ++i2) {
                    s2 = GF2Field.multElem(this.A[j][i2], s4);
                    s2 = GF2Field.multElem(s3, s2);
                    this.A[k][i2] = GF2Field.addElem(this.A[k][i2], s2);
                }
            }
        }
    }

    private void computeZerosAbove() throws RuntimeException {
        short s2 = 0;
        for (int j = this.A.length - 1; j > 0; --j) {
            for (int k = j - 1; k >= 0; --k) {
                short s3 = this.A[k][j];
                short s4 = GF2Field.invElem(this.A[j][j]);
                if (s4 == 0) {
                    throw new RuntimeException("The matrix is not invertible");
                }
                for (int i2 = j; i2 < 2 * this.A.length; ++i2) {
                    s2 = GF2Field.multElem(this.A[j][i2], s4);
                    s2 = GF2Field.multElem(s3, s2);
                    this.A[k][i2] = GF2Field.addElem(this.A[k][i2], s2);
                }
            }
        }
    }

    private void substitute() throws RuntimeException {
        short s2 = GF2Field.invElem(this.A[this.A.length - 1][this.A.length - 1]);
        if (s2 == 0) {
            throw new RuntimeException("The equation system is not solvable");
        }
        this.x[this.A.length - 1] = GF2Field.multElem(this.A[this.A.length - 1][this.A.length], s2);
        for (int j = this.A.length - 2; j >= 0; --j) {
            short s3 = this.A[j][this.A.length];
            for (int k = this.A.length - 1; k > j; --k) {
                s2 = GF2Field.multElem(this.A[j][k], this.x[k]);
                s3 = GF2Field.addElem(s3, s2);
            }
            s2 = GF2Field.invElem(this.A[j][j]);
            if (s2 == 0) {
                throw new RuntimeException("Not solvable equation system");
            }
            this.x[j] = GF2Field.multElem(s3, s2);
        }
    }

    public short[][] multiplyMatrix(short[][] sArray, short[][] sArray2) throws RuntimeException {
        if (sArray[0].length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short s2 = 0;
        this.A = new short[sArray.length][sArray2[0].length];
        for (int j = 0; j < sArray.length; ++j) {
            for (int k = 0; k < sArray2.length; ++k) {
                for (int i2 = 0; i2 < sArray2[0].length; ++i2) {
                    s2 = GF2Field.multElem(sArray[j][k], sArray2[k][i2]);
                    this.A[j][i2] = GF2Field.addElem(this.A[j][i2], s2);
                }
            }
        }
        return this.A;
    }

    public short[] multiplyMatrix(short[][] sArray, short[] sArray2) throws RuntimeException {
        if (sArray[0].length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short s2 = 0;
        short[] sArray3 = new short[sArray.length];
        for (int j = 0; j < sArray.length; ++j) {
            for (int k = 0; k < sArray2.length; ++k) {
                s2 = GF2Field.multElem(sArray[j][k], sArray2[k]);
                sArray3[j] = GF2Field.addElem(sArray3[j], s2);
            }
        }
        return sArray3;
    }

    public short[] addVect(short[] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[] sArray3 = new short[sArray.length];
        for (int j = 0; j < sArray3.length; ++j) {
            sArray3[j] = GF2Field.addElem(sArray[j], sArray2[j]);
        }
        return sArray3;
    }

    public short[][] multVects(short[] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[][] sArray3 = new short[sArray.length][sArray2.length];
        for (int j = 0; j < sArray.length; ++j) {
            for (int k = 0; k < sArray2.length; ++k) {
                sArray3[j][k] = GF2Field.multElem(sArray[j], sArray2[k]);
            }
        }
        return sArray3;
    }

    public short[] multVect(short s2, short[] sArray) {
        short[] sArray2 = new short[sArray.length];
        for (int j = 0; j < sArray2.length; ++j) {
            sArray2[j] = GF2Field.multElem(s2, sArray[j]);
        }
        return sArray2;
    }

    public short[][] multMatrix(short s2, short[][] sArray) {
        short[][] sArray2 = new short[sArray.length][sArray[0].length];
        for (int j = 0; j < sArray.length; ++j) {
            for (int k = 0; k < sArray[0].length; ++k) {
                sArray2[j][k] = GF2Field.multElem(s2, sArray[j][k]);
            }
        }
        return sArray2;
    }

    public short[][] addSquareMatrix(short[][] sArray, short[][] sArray2) {
        if (sArray.length != sArray2.length || sArray[0].length != sArray2[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        short[][] sArray3 = new short[sArray.length][sArray.length];
        for (int j = 0; j < sArray.length; ++j) {
            for (int k = 0; k < sArray2.length; ++k) {
                sArray3[j][k] = GF2Field.addElem(sArray[j][k], sArray2[j][k]);
            }
        }
        return sArray3;
    }
}

