/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Collections;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertyResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource;
import org.springframework.boot.context.properties.source.SpringConfigurationPropertySources;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;

public final class ConfigurationPropertySources {
    private static final String ATTACHED_PROPERTY_SOURCE_NAME = "configurationProperties";

    private ConfigurationPropertySources() {
    }

    public static ConfigurablePropertyResolver createPropertyResolver(MutablePropertySources propertySources) {
        return new ConfigurationPropertySourcesPropertyResolver(propertySources);
    }

    public static boolean isAttachedConfigurationPropertySource(PropertySource<?> propertySource) {
        return ATTACHED_PROPERTY_SOURCE_NAME.equals(propertySource.getName());
    }

    public static void attach(Environment environment2) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, environment2);
        MutablePropertySources sources = ((ConfigurableEnvironment)environment2).getPropertySources();
        PropertySource<?> attached = ConfigurationPropertySources.getAttached(sources);
        if (attached != null && attached.getSource() != sources) {
            sources.remove(ATTACHED_PROPERTY_SOURCE_NAME);
            attached = null;
        }
        if (attached == null) {
            sources.addFirst(new ConfigurationPropertySourcesPropertySource(ATTACHED_PROPERTY_SOURCE_NAME, new SpringConfigurationPropertySources(sources)));
        }
    }

    static PropertySource<?> getAttached(MutablePropertySources sources) {
        return sources != null ? sources.get(ATTACHED_PROPERTY_SOURCE_NAME) : null;
    }

    public static Iterable<ConfigurationPropertySource> get(Environment environment2) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, environment2);
        MutablePropertySources sources = ((ConfigurableEnvironment)environment2).getPropertySources();
        ConfigurationPropertySourcesPropertySource attached = (ConfigurationPropertySourcesPropertySource)sources.get(ATTACHED_PROPERTY_SOURCE_NAME);
        if (attached == null) {
            return ConfigurationPropertySources.from(sources);
        }
        return (Iterable)attached.getSource();
    }

    public static Iterable<ConfigurationPropertySource> from(PropertySource<?> source2) {
        return Collections.singleton(ConfigurationPropertySource.from(source2));
    }

    public static Iterable<ConfigurationPropertySource> from(Iterable<PropertySource<?>> sources) {
        return new SpringConfigurationPropertySources(sources);
    }

    private static Stream<PropertySource<?>> streamPropertySources(PropertySources sources) {
        return sources.stream().flatMap(ConfigurationPropertySources::flatten).filter(ConfigurationPropertySources::isIncluded);
    }

    private static Stream<PropertySource<?>> flatten(PropertySource<?> source2) {
        if (source2.getSource() instanceof ConfigurableEnvironment) {
            return ConfigurationPropertySources.streamPropertySources(((ConfigurableEnvironment)source2.getSource()).getPropertySources());
        }
        return Stream.of(source2);
    }

    private static boolean isIncluded(PropertySource<?> source2) {
        return !(source2 instanceof PropertySource.StubPropertySource) && !(source2 instanceof ConfigurationPropertySourcesPropertySource);
    }
}

