/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health.reactive;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.health.CompositeReactiveHealthContributor;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryHealthIndicator;
import org.springframework.util.Assert;

public class ReactiveDiscoveryCompositeHealthContributor
implements CompositeReactiveHealthContributor {
    private Map<String, ReactiveDiscoveryHealthIndicator> indicators;

    public ReactiveDiscoveryCompositeHealthContributor(Collection<ReactiveDiscoveryHealthIndicator> indicators) {
        Assert.notNull(indicators, "'indicators' must not be null");
        this.indicators = indicators.stream().collect(Collectors.toMap(ReactiveDiscoveryHealthIndicator::getName, Function.identity()));
    }

    public ReactiveHealthContributor getContributor(String name) {
        return this.asHealthIndicator(this.indicators.get(name));
    }

    public Iterator<NamedContributor<ReactiveHealthContributor>> iterator() {
        return this.indicators.values().stream().map(this::asNamedContributor).iterator();
    }

    private NamedContributor<ReactiveHealthContributor> asNamedContributor(final ReactiveDiscoveryHealthIndicator indicator) {
        return new NamedContributor<ReactiveHealthContributor>(){

            public String getName() {
                return indicator.getName();
            }

            public ReactiveHealthContributor getContributor() {
                return ReactiveDiscoveryCompositeHealthContributor.this.asHealthIndicator(indicator);
            }
        };
    }

    private ReactiveHealthIndicator asHealthIndicator(ReactiveDiscoveryHealthIndicator indicator) {
        return indicator != null ? indicator::health : null;
    }
}

