/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public abstract class SpringFactoryImportSelector<T>
implements DeferredImportSelector,
BeanClassLoaderAware,
EnvironmentAware {
    private final Log log = LogFactory.getLog(SpringFactoryImportSelector.class);
    private ClassLoader beanClassLoader;
    private Class<T> annotationClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), SpringFactoryImportSelector.class);
    private Environment environment;

    protected SpringFactoryImportSelector() {
    }

    @Override
    public String[] selectImports(AnnotationMetadata metadata) {
        if (!this.isEnabled()) {
            return new String[0];
        }
        AnnotationAttributes attributes = AnnotationAttributes.fromMap(metadata.getAnnotationAttributes(this.annotationClass.getName(), true));
        Assert.notNull((Object)attributes, "No " + this.getSimpleName() + " attributes found. Is " + metadata.getClassName() + " annotated with @" + this.getSimpleName() + "?");
        ArrayList<String> factories = new ArrayList<String>(new LinkedHashSet<String>(SpringFactoriesLoader.loadFactoryNames(this.annotationClass, this.beanClassLoader)));
        if (factories.isEmpty() && !this.hasDefaultFactory()) {
            throw new IllegalStateException("Annotation @" + this.getSimpleName() + " found, but there are no implementations. Did you forget to include a starter?");
        }
        if (factories.size() > 1) {
            this.log.warn("More than one implementation of @" + this.getSimpleName() + " (now relying on @Conditionals to pick one): " + factories);
        }
        return factories.toArray(new String[factories.size()]);
    }

    protected boolean hasDefaultFactory() {
        return false;
    }

    protected abstract boolean isEnabled();

    protected String getSimpleName() {
        return this.annotationClass.getSimpleName();
    }

    protected Class<T> getAnnotationClass() {
        return this.annotationClass;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void setEnvironment(Environment environment2) {
        this.environment = environment2;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }
}

