/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.client.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.NoSuchElementException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.wildfly.client.config.AbstractDelegatingXMLStreamReader;
import org.wildfly.client.config.BasicXMLStreamReader;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.DrainingXMLStreamReader;
import org.wildfly.client.config.ScopedXMLStreamReader;
import org.wildfly.client.config.TextXMLStreamReader;
import org.wildfly.client.config._private.ConfigMessages;

final class XIncludeXMLStreamReader
extends AbstractDelegatingXMLStreamReader {
    static final String XINCLUDE_NS = "http://www.w3.org/2001/XInclude";
    private ConfigurationXMLStreamReader child;

    XIncludeXMLStreamReader(ConfigurationXMLStreamReader delegate) {
        super(true, delegate);
    }

    private ConfigurationXMLStreamReader getRawDelegate() {
        return super.getDelegate();
    }

    @Override
    protected ConfigurationXMLStreamReader getDelegate() {
        ConfigurationXMLStreamReader child = this.child;
        return child != null ? child : this.getRawDelegate();
    }

    @Override
    public void skipContent() throws ConfigXMLParseException {
        while (this.getDelegate().hasNext()) {
            switch (this.getDelegate().next()) {
                case 1: {
                    this.skipContent();
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int next() throws ConfigXMLParseException {
        int res;
        ConfigurationXMLStreamReader delegate;
        ConfigurationXMLStreamReader child = this.child;
        if (child != null) {
            if (child.hasNext()) {
                int next = child.next();
                if (next != 8) {
                    return next;
                }
                child.close();
            }
            this.child = null;
        }
        if (!(delegate = this.getDelegate()).hasNext()) {
            throw new NoSuchElementException();
        }
        block19: while ((res = delegate.next()) == 1) {
            String namespaceURI = delegate.getNamespaceURI();
            if (XINCLUDE_NS.equals(namespaceURI)) {
                switch (delegate.getLocalName()) {
                    case "include": {
                        ConfigurationXMLStreamReader nested = this.processInclude();
                        boolean ok = false;
                        try {
                            if (nested != null && nested.hasNext()) {
                                int eventType = nested.next();
                                if (eventType == 7) {
                                    if (!nested.hasNext()) continue block19;
                                    eventType = nested.next();
                                }
                                this.child = new XIncludeXMLStreamReader(nested);
                                ok = true;
                                int n = eventType;
                                return n;
                            }
                            ok = true;
                            continue block19;
                        }
                        finally {
                            if (ok) continue block19;
                            try {
                                nested.close();
                            }
                            catch (ConfigXMLParseException configXMLParseException) {}
                            continue block19;
                        }
                    }
                }
                throw ConfigMessages.msg.unexpectedElement(delegate.getLocalName(), namespaceURI, this.getLocation());
            }
            return res;
        }
        return res;
    }

    private ConfigurationXMLStreamReader processInclude() throws ConfigXMLParseException {
        ScopedXMLStreamReader includeElement = new ScopedXMLStreamReader(false, this.getRawDelegate());
        ConfigurationXMLStreamReader delegate = this.getDelegate();
        int attributeCount = delegate.getAttributeCount();
        URI href = null;
        Charset textCharset = StandardCharsets.UTF_8;
        boolean fallback = false;
        String accept = null;
        String acceptLanguage = null;
        boolean parseAsText = false;
        block49: for (int i2 = 0; i2 < attributeCount; ++i2) {
            if (delegate.getAttributeNamespace(i2) != null) continue;
            switch (delegate.getAttributeLocalName(i2)) {
                case "href": {
                    try {
                        href = new URI(delegate.getAttributeValue(i2));
                    }
                    catch (URISyntaxException e) {
                        throw new ConfigXMLParseException("Invalid include URI", (Location)this.getLocation(), (Throwable)e);
                    }
                    if (href.getFragment() != null) {
                        throw new ConfigXMLParseException("Invalid include URI: must not contain fragment identifier", (Location)this.getLocation());
                    }
                    fallback |= href.isOpaque();
                    continue block49;
                }
                case "parse": {
                    switch (delegate.getAttributeValue(i2)) {
                        case "xml": {
                            parseAsText = false;
                            continue block49;
                        }
                        case "text": {
                            parseAsText = true;
                            continue block49;
                        }
                    }
                    throw new ConfigXMLParseException("Invalid include directive: unknown parse type (must be \"text\" or \"xml\")", (Location)this.getLocation());
                }
                case "xpointer": {
                    fallback = true;
                    continue block49;
                }
                case "encoding": {
                    try {
                        textCharset = Charset.forName(delegate.getAttributeValue(i2));
                    }
                    catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                        fallback = true;
                    }
                    continue block49;
                }
                case "accept": {
                    accept = delegate.getAttributeValue(i2);
                    continue block49;
                }
                case "accept-language": {
                    acceptLanguage = delegate.getAttributeValue(i2);
                }
            }
        }
        if (!fallback) {
            ConfigurationXMLStreamReader child;
            if (href == null) {
                throw delegate.missingRequiredAttribute(null, "href");
            }
            try {
                if (!href.isAbsolute()) {
                    href = this.getRawDelegate().getUri().resolve(href);
                }
                URL url = href.toURL();
                URLConnection connection = url.openConnection();
                connection.addRequestProperty("Accept", accept != null ? accept : (parseAsText ? "text/plain,text/*" : "application/xml,text/xml,application/*+xml,text/*+xml"));
                if (acceptLanguage != null) {
                    connection.addRequestProperty("Accept-Language", acceptLanguage);
                }
                InputStream inputStream2 = connection.getInputStream();
                try {
                    child = parseAsText ? new TextXMLStreamReader(textCharset, inputStream2, (ConfigurationXMLStreamReader)this, href) : new XIncludeXMLStreamReader(new BasicXMLStreamReader(this.getLocation(), this.getXmlInputFactory().createXMLStreamReader(inputStream2), href, this.getXmlInputFactory(), inputStream2));
                }
                catch (XMLStreamException e) {
                    try {
                        inputStream2.close();
                    }
                    catch (Throwable e1) {
                        e.addSuppressed(e1);
                    }
                    throw ConfigXMLParseException.from(e, this.getUri(), this.getIncludedFrom());
                }
                catch (Throwable t) {
                    try {
                        inputStream2.close();
                    }
                    catch (Throwable e1) {
                        t.addSuppressed(e1);
                    }
                    throw t;
                }
            }
            catch (IOException e) {
                throw ConfigXMLParseException.from(e, this.getUri(), this.getIncludedFrom());
            }
            try {
                this.getRawDelegate().skipContent();
                return child;
            }
            catch (Throwable t) {
                try {
                    child.close();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }
        block50: while (super.hasNext()) {
            block32 : switch (super.next()) {
                case 1: {
                    if (XINCLUDE_NS.equals(super.getNamespaceURI()) && "fallback".equals(super.getLocalName())) {
                        this.child = new ScopedXMLStreamReader(true, new DrainingXMLStreamReader(false, includeElement));
                        return this.child;
                    }
                    int level = 0;
                    while (super.hasNext()) {
                        switch (super.next()) {
                            case 1: {
                                ++level;
                                break;
                            }
                            case 2: {
                                if (level-- == 0) break block32;
                            }
                        }
                    }
                    continue block50;
                }
                case 2: {
                    return null;
                }
            }
        }
        return null;
    }
}

