/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.xnio.Option;
import org.xnio.Sequence;
import org.xnio._private.Messages;

public final class OptionMap
implements Iterable<Option<?>>,
Serializable {
    private static final long serialVersionUID = 3632842565346928132L;
    private final Map<Option<?>, Object> value;
    public static final OptionMap EMPTY = new OptionMap(Collections.emptyMap());

    private OptionMap(Map<Option<?>, Object> value) {
        this.value = value;
    }

    public boolean contains(Option<?> option) {
        return this.value.containsKey(option);
    }

    public <T> T get(Option<T> option) {
        return option.cast(this.value.get(option));
    }

    public <T> T get(Option<T> option, T defaultValue) {
        Object o = this.value.get(option);
        return o == null ? defaultValue : option.cast(o);
    }

    public boolean get(Option<Boolean> option, boolean defaultValue) {
        Object o = this.value.get(option);
        return o == null ? defaultValue : option.cast(o);
    }

    public int get(Option<Integer> option, int defaultValue) {
        Object o = this.value.get(option);
        return o == null ? defaultValue : option.cast(o);
    }

    public long get(Option<Long> option, long defaultValue) {
        Object o = this.value.get(option);
        return o == null ? defaultValue : option.cast(o);
    }

    @Override
    public Iterator<Option<?>> iterator() {
        return Collections.unmodifiableCollection(this.value.keySet()).iterator();
    }

    public int size() {
        return this.value.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> OptionMap create(Option<T> option, T value) {
        if (option == null) {
            throw Messages.msg.nullParameter("option");
        }
        if (value == null) {
            throw Messages.msg.nullParameter("value");
        }
        return new OptionMap(Collections.singletonMap(option, option.cast(value)));
    }

    public static <T1, T2> OptionMap create(Option<T1> option1, T1 value1, Option<T2> option2, T2 value2) {
        if (option1 == null) {
            throw Messages.msg.nullParameter("option1");
        }
        if (value1 == null) {
            throw Messages.msg.nullParameter("value1");
        }
        if (option2 == null) {
            throw Messages.msg.nullParameter("option2");
        }
        if (value2 == null) {
            throw Messages.msg.nullParameter("value2");
        }
        if (option1 == option2) {
            return OptionMap.create(option2, value2);
        }
        IdentityHashMap map = new IdentityHashMap(2);
        map.put(option1, value1);
        map.put(option2, value2);
        return new OptionMap(map);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        Iterator<Map.Entry<Option<?>, Object>> iterator2 = this.value.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Option<?>, Object> entry = iterator2.next();
            builder.append(entry.getKey()).append("=>").append(entry.getValue());
            if (!iterator2.hasNext()) continue;
            builder.append(',');
        }
        builder.append('}');
        return builder.toString();
    }

    public boolean equals(Object other) {
        return other instanceof OptionMap && this.equals((OptionMap)other);
    }

    public boolean equals(OptionMap other) {
        return this == other || other != null && this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static final class Builder {
        private List<OVPair<?>> list = new ArrayList();

        private Builder() {
        }

        public <T> Builder parse(Option<T> key, String stringValue) {
            this.set(key, key.parseValue(stringValue, key.getClass().getClassLoader()));
            return this;
        }

        public <T> Builder parse(Option<T> key, String stringValue, ClassLoader classLoader) {
            this.set(key, key.parseValue(stringValue, classLoader));
            return this;
        }

        public Builder parseAll(Properties props, String prefix, ClassLoader optionClassLoader) {
            if (!prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            for (String name : props.stringPropertyNames()) {
                if (!name.startsWith(prefix)) continue;
                String optionName = name.substring(prefix.length());
                try {
                    Option<?> option = Option.fromString(optionName, optionClassLoader);
                    this.parse(option, props.getProperty(name), optionClassLoader);
                }
                catch (IllegalArgumentException e) {
                    Messages.optionParseMsg.invalidOptionInProperty(optionName, name, e);
                }
            }
            return this;
        }

        public Builder parseAll(Properties props, String prefix) {
            if (!prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            for (String name : props.stringPropertyNames()) {
                if (!name.startsWith(prefix)) continue;
                String optionName = name.substring(prefix.length());
                try {
                    Option<?> option = Option.fromString(optionName, this.getClass().getClassLoader());
                    this.parse(option, props.getProperty(name));
                }
                catch (IllegalArgumentException e) {
                    Messages.optionParseMsg.invalidOptionInProperty(optionName, name, e);
                }
            }
            return this;
        }

        public <T> Builder set(Option<T> key, T value) {
            if (key == null) {
                throw Messages.msg.nullParameter("key");
            }
            if (value == null) {
                throw Messages.msg.nullParameter("value");
            }
            this.list.add(new OVPair(key, value));
            return this;
        }

        public Builder set(Option<Integer> key, int value) {
            if (key == null) {
                throw Messages.msg.nullParameter("key");
            }
            this.list.add(new OVPair(key, value));
            return this;
        }

        public Builder setSequence(Option<Sequence<Integer>> key, int ... values2) {
            if (key == null) {
                throw Messages.msg.nullParameter("key");
            }
            Integer[] a = new Integer[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                a[i2] = values2[i2];
            }
            this.list.add(new OVPair(key, Sequence.of(a)));
            return this;
        }

        public Builder set(Option<Long> key, long value) {
            if (key == null) {
                throw Messages.msg.nullParameter("key");
            }
            this.list.add(new OVPair(key, value));
            return this;
        }

        public Builder setSequence(Option<Sequence<Long>> key, long ... values2) {
            if (key == null) {
                throw Messages.msg.nullParameter("key");
            }
            Long[] a = new Long[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                a[i2] = values2[i2];
            }
            this.list.add(new OVPair(key, Sequence.of(a)));
            return this;
        }

        public Builder set(Option<Boolean> key, boolean value) {
            if (key == null) {
                throw Messages.msg.nullParameter("key");
            }
            this.list.add(new OVPair(key, value));
            return this;
        }

        public Builder setSequence(Option<Sequence<Boolean>> key, boolean ... values2) {
            if (key == null) {
                throw Messages.msg.nullParameter("key");
            }
            Boolean[] a = new Boolean[values2.length];
            for (int i2 = 0; i2 < values2.length; ++i2) {
                a[i2] = values2[i2];
            }
            this.list.add(new OVPair(key, Sequence.of(a)));
            return this;
        }

        public <T> Builder setSequence(Option<Sequence<T>> key, T ... values2) {
            if (key == null) {
                throw Messages.msg.nullParameter("key");
            }
            this.list.add(new OVPair(key, Sequence.of(values2)));
            return this;
        }

        private <T> void copy(Map<?, ?> map, Option<T> option) {
            this.set(option, option.cast(map.get(option)));
        }

        public Builder add(Map<?, ?> map) throws ClassCastException {
            for (Object key : map.keySet()) {
                Option option = (Option)Option.class.cast(key);
                this.copy(map, option);
            }
            return this;
        }

        private <T> void copy(OptionMap optionMap, Option<T> option) {
            this.set(option, optionMap.get(option));
        }

        public Builder addAll(OptionMap optionMap) {
            for (Option<?> option : optionMap) {
                this.copy(optionMap, option);
            }
            return this;
        }

        public OptionMap getMap() {
            List<OVPair<?>> list = this.list;
            if (list.size() == 0) {
                return EMPTY;
            }
            if (list.size() == 1) {
                OVPair<?> pair = list.get(0);
                return new OptionMap(Collections.singletonMap(pair.option, pair.value));
            }
            IdentityHashMap map = new IdentityHashMap();
            for (OVPair<?> ovPair : list) {
                map.put(ovPair.option, ovPair.value);
            }
            return new OptionMap(map);
        }

        private static class OVPair<T> {
            Option<T> option;
            T value;

            private OVPair(Option<T> option, T value) {
                this.option = option;
                this.value = value;
            }
        }
    }
}

