/*
 * Decompiled with CFR 0.152.
 */
package com.volar.systemdev.sentinel.exception;

import com.alibaba.csp.sentinel.slots.block.authority.AuthorityException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import common.config.tools.config.ConfigTools3;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class SentinelExceptionHandler {
    @ExceptionHandler(value={FlowException.class})
    @ResponseBody
    public ResponseEntity<String> handleFlowException(FlowException e) {
        String flowControlMessage = ConfigTools3.getConfigAsString((String)"sentinel.flowControlMessage", (String)"System is busy due to flow control, please try again later.");
        return ResponseEntity.status((int)429).body((Object)flowControlMessage);
    }

    @ExceptionHandler(value={DegradeException.class})
    @ResponseBody
    public ResponseEntity<String> handleDegradeException(DegradeException e) {
        String degradeMessage = ConfigTools3.getConfigAsString((String)"sentinel.degradeMessage", (String)"System is degraded, please try again later.");
        return ResponseEntity.status((int)429).body((Object)degradeMessage);
    }

    @ExceptionHandler(value={ParamFlowException.class})
    @ResponseBody
    public ResponseEntity<String> handleParamFlowException(ParamFlowException e) {
        String paramFlowMessage = ConfigTools3.getConfigAsString((String)"sentinel.paramFlowMessage", (String)"System is busy due to param flow control, please try again later.");
        return ResponseEntity.status((int)429).body((Object)paramFlowMessage);
    }

    @ExceptionHandler(value={AuthorityException.class})
    @ResponseBody
    public ResponseEntity<String> handleAuthorityException(AuthorityException e) {
        String authorityMessage = ConfigTools3.getConfigAsString((String)"sentinel.authorityMessage", (String)"Access denied due to authority rules.");
        return ResponseEntity.status((int)403).body((Object)authorityMessage);
    }

    @ExceptionHandler(value={SystemBlockException.class})
    @ResponseBody
    public ResponseEntity<String> handleSystemBlockException(SystemBlockException e) {
        String systemBlockMessage = ConfigTools3.getConfigAsString((String)"sentinel.systemBlockMessage", (String)"System is blocked, please try again later.");
        return ResponseEntity.status((int)429).body((Object)systemBlockMessage);
    }
}

