/*
 * Decompiled with CFR 0.152.
 */
package com.volar.systemdev.sentinel.exception;

import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import comm.base.tools.api.exception.ApiException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.MethodArgumentNotValidException;

@Aspect
@Component
public class SentinelExceptionAspect {
    @Pointcut(value="@annotation(com.volar.systemdev.sentinel.exception.SentinelExceptionResource)")
    public void sentinelExceptionPointcut() {
    }

    @Around(value="sentinelExceptionPointcut()")
    public Object invokeResourceWithSentinel(ProceedingJoinPoint pjp) throws Throwable {
        try {
            return pjp.proceed();
        }
        catch (Throwable ex) {
            if (ex instanceof BlockException || ex instanceof IllegalArgumentException || ex instanceof ApiException || ex instanceof MethodArgumentNotValidException) {
                throw ex;
            }
            Tracer.trace((Throwable)ex);
            throw ex;
        }
    }
}

