/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.bloomFilter;

import com.xiaoleilu.hutool.bloomFilter.BloomFilter;
import com.xiaoleilu.hutool.bloomFilter.filter.DefaultFilter;
import com.xiaoleilu.hutool.bloomFilter.filter.ELFFilter;
import com.xiaoleilu.hutool.bloomFilter.filter.JSFilter;
import com.xiaoleilu.hutool.bloomFilter.filter.PJWFilter;
import com.xiaoleilu.hutool.bloomFilter.filter.SDBMFilter;

public class BitMapBloomFilter
implements BloomFilter {
    private BloomFilter[] filters;

    public BitMapBloomFilter(int m) {
        float mNum = m / 5;
        long size = (long)(1.0f * mNum * 1024.0f * 1024.0f * 8.0f);
        this.filters = new BloomFilter[]{new DefaultFilter(size), new ELFFilter(size), new JSFilter(size), new PJWFilter(size), new SDBMFilter(size)};
    }

    public BitMapBloomFilter(int m, BloomFilter ... filters) {
        this.filters = filters;
    }

    @Override
    public boolean add(String str) {
        boolean flag = true;
        for (BloomFilter filter : this.filters) {
            flag &= filter.add(str);
        }
        return flag;
    }

    @Override
    public boolean contains(String str) {
        for (BloomFilter filter : this.filters) {
            if (filter.contains(str)) continue;
            return false;
        }
        return true;
    }
}

