/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.ds.AbstractDataSource;
import com.xiaoleilu.hutool.exceptions.DbRuntimeException;
import com.xiaoleilu.hutool.setting.Setting;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class SimpleDataSource
extends AbstractDataSource {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private String driver;
    private String url;
    private String user;
    private String pass;

    public static synchronized SimpleDataSource getDataSource(String group) {
        return new SimpleDataSource(group);
    }

    public static synchronized SimpleDataSource getDataSource() {
        return new SimpleDataSource();
    }

    public SimpleDataSource() {
        this(null);
    }

    public SimpleDataSource(String group) {
        this(null, group);
    }

    public SimpleDataSource(Setting setting, String group) {
        if (null == setting) {
            setting = new Setting(DEFAULT_DB_CONFIG_PATH);
        }
        this.init(setting.getString("url", group), setting.getString("user", group), setting.getString("pass", group));
    }

    public SimpleDataSource(String url, String user, String pass) {
        this.init(url, user, pass);
    }

    public void init(String url, String user, String pass) {
        this.url = url;
        this.user = user;
        this.pass = pass;
        this.driver = DbUtil.identifyDriver(url);
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new DbRuntimeException(e, "Get jdbc driver from [{}] error!", url);
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.pass);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return DriverManager.getConnection(this.url, username, password);
    }

    @Override
    public void close() throws IOException {
    }
}

