/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.pool;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.ds.pool.DbConfig;
import com.xiaoleilu.hutool.setting.Setting;

public class DbSetting {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private Setting setting;

    public DbSetting() {
        this(null);
    }

    public DbSetting(Setting setting) {
        if (null == setting) {
            this.setting = new Setting(DEFAULT_DB_CONFIG_PATH);
        }
    }

    public DbConfig getDbConfig(String group) {
        DbConfig config = new DbConfig();
        String jdbcUrl = this.setting.getString("url", group);
        config.setDriver(this.setting.getStringWithDefault("driver", group, DbUtil.identifyDriver(jdbcUrl)));
        config.setUrl(jdbcUrl);
        config.setUser(this.setting.getStr("user", group));
        config.setPass(this.setting.getStr("pass", group));
        config.setInitialSize(this.setting.getInt("initialSize", 0));
        config.setMinIdle(this.setting.getInt("minIdle", 0));
        config.setMaxActive(this.setting.getInt("maxActive", 8));
        config.setMaxWait(this.setting.getLong("maxWait", 6000L));
        return config;
    }
}

