/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.dfa;

import com.xiaoleilu.hutool.dfa.WordTree;
import com.xiaoleilu.hutool.json.JSONUtil;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.ThreadUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class SensitiveUtil {
    private static final Log log = LogFactory.get();
    private static WordTree sensitiveTree = new WordTree();
    public static final char DEFAULT_SEPARATOR = ',';

    public static boolean isInited() {
        return !sensitiveTree.isEmpty();
    }

    public static void init(final Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            ThreadUtil.execAsync(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    SensitiveUtil.init(sensitiveWords);
                    return true;
                }
            });
        } else {
            SensitiveUtil.init(sensitiveWords);
        }
    }

    public static void init(Collection<String> sensitiveWords) {
        sensitiveTree.clear();
        sensitiveTree.addWords(sensitiveWords);
        log.debug("Sensitive init finished, sensitives: {}", sensitiveWords);
    }

    public static void init(String sensitiveWords, char separator, boolean isAsync) {
        if (StrUtil.isNotBlank(sensitiveWords)) {
            SensitiveUtil.init(StrUtil.split(sensitiveWords, separator), isAsync);
        }
    }

    public static void init(String sensitiveWords, boolean isAsync) {
        SensitiveUtil.init(sensitiveWords, ',', isAsync);
    }

    public static boolean containsSensitive(String text) {
        return sensitiveTree.isMatch(text);
    }

    public static boolean containsSensitive(Object obj) {
        return sensitiveTree.isMatch(JSONUtil.toJsonStr(obj));
    }

    public static String getFindedFirstSensitive(String text) {
        return sensitiveTree.match(text);
    }

    public static String getFindedFirstSensitive(Object obj) {
        return sensitiveTree.match(JSONUtil.toJsonStr(obj));
    }

    public static List<String> getFindedAllSensitive(String text) {
        return sensitiveTree.matchAll(text);
    }

    public static List<String> getFindedAllSensitive(Object bean) {
        return sensitiveTree.matchAll(JSONUtil.toJsonStr(bean));
    }
}

