/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.dfa;

import com.xiaoleilu.hutool.dfa.StopChar;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WordTree
extends HashMap<Character, WordTree> {
    private static final long serialVersionUID = -4646423269465809276L;
    public static final int DEFAULT_GROUP = 0;
    public Map<Integer, Boolean> groups = new HashMap<Integer, Boolean>();

    public WordTree() {
    }

    public WordTree(int group) {
        this.groups.put(group, false);
    }

    public void addWords(Collection<String> words) {
        this.addWords(words, 0);
    }

    public void addWords(Collection<String> words, int group) {
        if (!(words instanceof Set)) {
            words = new HashSet<String>(words);
        }
        for (String word : words) {
            this.addWord(word, group);
        }
    }

    public void addWord(String word) {
        this.addWord(word, 0);
    }

    public void addWord(String word, int group) {
        WordTree current = this;
        int length = word.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = word.charAt(i);
            if (!StopChar.isStopChar(currentChar)) {
                WordTree child = (WordTree)current.get(Character.valueOf(currentChar));
                if (child == null) {
                    child = new WordTree(group);
                    current.put(Character.valueOf(currentChar), child);
                }
                current = child;
            }
            current.setEnd(group, true);
        }
    }

    public boolean isMatch(String text) {
        return this.isMatch(text, 0);
    }

    public boolean isMatch(String text, int group) {
        if (null == text) {
            return false;
        }
        WordTree current = this;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            for (int j = i; j < length; ++j) {
                char currentChar = text.charAt(j);
                if (StopChar.isStopChar(currentChar)) continue;
                if (!current.containsKey(Character.valueOf(currentChar))) break;
                if (current.isEnd(group)) {
                    return true;
                }
                WordTree child = (WordTree)current.get(Character.valueOf(currentChar));
                if (null == child) continue;
                current = child;
            }
            current = this;
        }
        return false;
    }

    public String match(String text) {
        return this.match(text, 0);
    }

    public String match(String text, int group) {
        if (null == text) {
            return null;
        }
        WordTree current = this;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            StringBuilder sb = StrUtil.builder();
            for (int j = i; j < length; ++j) {
                char currentChar = text.charAt(j);
                if (StopChar.isStopChar(currentChar)) continue;
                if (!current.containsKey(Character.valueOf(currentChar))) break;
                sb.append(currentChar);
                if (current.isEnd(group)) {
                    return sb.toString();
                }
                WordTree child = (WordTree)current.get(Character.valueOf(currentChar));
                if (null == child) continue;
                current = child;
            }
            current = this;
        }
        return null;
    }

    public List<String> matchAll(String text) {
        return this.matchAll(text, 0);
    }

    public List<String> matchAll(String text, int group) {
        if (null == text) {
            return null;
        }
        ArrayList<String> findedWords = new ArrayList<String>();
        WordTree current = this;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            StringBuilder sb = StrUtil.builder();
            for (int j = i; j < length; ++j) {
                char currentChar = text.charAt(j);
                if (StopChar.isStopChar(currentChar)) continue;
                if (!current.containsKey(Character.valueOf(currentChar))) break;
                sb.append(currentChar);
                if (current.isEnd(group)) {
                    findedWords.add(sb.toString());
                    i = j + 1;
                    break;
                }
                WordTree child = (WordTree)current.get(Character.valueOf(currentChar));
                if (null == child) continue;
                current = child;
            }
            current = this;
        }
        return findedWords;
    }

    private boolean isEnd(int group) {
        Boolean isEnd = this.groups.get(group);
        return null != isEnd && isEnd != false;
    }

    private void setEnd(int group, boolean isEnd) {
        this.groups.put(group, isEnd);
    }
}

