/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.exceptions;

import com.xiaoleilu.hutool.io.FastByteArrayOutputStream;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public class ExceptionUtil {
    public static String getMessage(Throwable e) {
        return StrUtil.format("{}: {}", e.getClass().getSimpleName(), e.getMessage());
    }

    public static Throwable unwrap(Throwable wrapped) {
        Throwable unwrapped = wrapped;
        while (true) {
            if (unwrapped instanceof InvocationTargetException) {
                unwrapped = ((InvocationTargetException)unwrapped).getTargetException();
                continue;
            }
            if (!(unwrapped instanceof UndeclaredThrowableException)) break;
            unwrapped = ((UndeclaredThrowableException)unwrapped).getUndeclaredThrowable();
        }
        return unwrapped;
    }

    public static String stacktraceToString(Throwable throwable, int limit) {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(baos));
        String exceptionStr = baos.toString();
        int length = exceptionStr.length();
        if (limit > 0 && limit < length) {
            length = limit;
        }
        StringBuilder sb = StrUtil.builder();
        block5: for (int i = 0; i < length; ++i) {
            char c = exceptionStr.charAt(i);
            switch (c) {
                case '\r': {
                    continue block5;
                }
                case '\n': {
                    sb.append(' ');
                    continue block5;
                }
                case '\t': {
                    sb.append(' ');
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

