/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect;

import com.xiaoleilu.hutool.log.AbstractLog;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JdkLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;
    private static final String SELF = JdkLog.class.getName();
    private static final String SUPER = JdkLog.class.getSuperclass().getName();

    public JdkLog(Logger logger) {
        this.logger = logger;
    }

    public JdkLog(Class<?> clazz) {
        this(clazz.getName());
    }

    public JdkLog(String name) {
        this(Logger.getLogger(name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.log(SELF, Level.FINEST, StrUtil.format(format, arguments), null);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.log(SELF, Level.FINEST, StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.log(SELF, Level.FINE, StrUtil.format(format, arguments), null);
        }
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.log(SELF, Level.FINE, StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.log(SELF, Level.INFO, StrUtil.format(format, arguments), null);
        }
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.log(SELF, Level.INFO, StrUtil.format(format, arguments), null);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.log(SELF, Level.WARNING, StrUtil.format(format, arguments), null);
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.log(SELF, Level.WARNING, StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.log(SELF, Level.SEVERE, StrUtil.format(format, arguments), null);
        }
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.log(SELF, Level.SEVERE, StrUtil.format(format, arguments), t);
        }
    }

    private void log(String callerFQCN, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.getName());
        record.setThrown(t);
        JdkLog.fillCallerData(callerFQCN, record);
        this.logger.log(record);
    }

    private static void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int selfIndex = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!className.equals(callerFQCN) && !className.equals(SUPER)) continue;
            selfIndex = i;
            break;
        }
        int found = -1;
        for (int i = selfIndex + 1; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (className.equals(callerFQCN) || className.equals(SUPER)) continue;
            found = i;
            break;
        }
        if (found != -1) {
            StackTraceElement ste = steArray[found];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }
}

