/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect;

import com.xiaoleilu.hutool.log.AbstractLog;
import com.xiaoleilu.hutool.util.StrUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = Log4jLog.class.getName();
    private final transient Logger logger;

    public Log4jLog(Logger logger) {
        this.logger = logger;
    }

    public Log4jLog(Class<?> clazz) {
        this(Logger.getLogger(clazz));
    }

    public Log4jLog(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.TRACE, (Object)StrUtil.format(format, arguments), t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)StrUtil.format(format, arguments), t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)StrUtil.format(format, arguments), t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)StrUtil.format(format, arguments), t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)StrUtil.format(format, arguments), t);
    }
}

